/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import net.scheinerman.phoenix.interpreter.LoopInterpreter;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForInterpreter
extends LoopInterpreter {
    protected boolean firstLoop = true;
    private boolean initialization = false;
    private String startCondition;
    private String endCondition;
    private String incCondition;

    public ForInterpreter(String file, String code, int line, String forStatement, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        super(file, code, line, vat, fat);
        String[] parts = forStatement.split(";");
        if (parts.length != 3) {
            throw new SyntaxException("For statement must have exactly three arguments.");
        }
        parts[0] = parts[0].trim();
        this.startCondition = parts[0];
        this.endCondition = parts[1];
        this.incCondition = parts[2];
    }

    @Override
    protected boolean isDone() {
        if (this.firstLoop) {
            this.firstLoop = false;
            return this.endConditionMet();
        }
        this.parsePhrase(this.incCondition);
        return this.endConditionMet();
    }

    private boolean endConditionMet() {
        Variable v = this.parsePhrase(this.endCondition);
        if (!(v instanceof NumberVariable)) {
            throw new SyntaxException("End condition of for must return a number variable.");
        }
        NumberVariable nv = (NumberVariable)v;
        return nv.value() == 0.0;
    }

    @Override
    protected void beforeStart() {
        if (this.startCondition.startsWith("num ") || this.startCondition.startsWith("str ")) {
            this.initialization = true;
            this.makeVariable(this.startCondition);
            this.initNewTables();
        } else {
            this.parsePhrase(this.startCondition);
        }
    }

    @Override
    protected void afterEnd() {
        if (this.initialization) {
            this.vat.removeFirst();
            this.fat.removeFirst();
        }
    }
}

