/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.scheinerman.phoenix.interpreter.Condition;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfInterpreter {
    protected int breakValue = 0;
    protected boolean _break = false;
    protected boolean _continue = false;
    protected boolean _return = false;
    protected Variable retValue = null;
    private String file;
    private Interpreter interpreter;
    private ArrayList<Condition> conditions;
    private LinkedList<HashMap<String, Variable>> vat;
    private LinkedList<HashMap<String, Function>> fat;

    public IfInterpreter(String file, ArrayList<Condition> conditions, Interpreter interpreter, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        this.file = file;
        this.conditions = conditions;
        this.interpreter = interpreter;
        this.vat = vat;
        this.fat = fat;
    }

    public void run() {
        for (Condition condition : this.conditions) {
            Variable result = this.interpreter.parsePhrase(condition.getCondition());
            if (result instanceof StringVariable) {
                throw new SyntaxException("If / else conditions must return number variables.");
            }
            NumberVariable var = (NumberVariable)result;
            if (var.value() == 0.0) continue;
            Interpreter temp = new Interpreter(false, this.file, condition.getCode(), condition.getLine(), this.vat, this.fat);
            temp.run();
            if (temp._break) {
                this.dealWithBreak(temp.breakValue);
            }
            if (temp._continue) {
                this.dealWithContinue();
            }
            if (!temp._return) break;
            this.dealWithReturn(temp.retValue);
            break;
        }
    }

    protected void dealWithBreak(int value) {
        this.breakValue = value;
        this._break = true;
    }

    protected void dealWithContinue() {
        this._continue = true;
    }

    protected void dealWithReturn(Variable passed) {
        this.retValue = passed;
        this._return = true;
    }
}

