/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInterpreter
extends Interpreter {
    public static final int ALL = 0;
    public static final int GLOBAL_ONLY = 1;
    public static final int ALL_AS_GLOBAL = 2;
    public static final int LOCAL_ONLY = 3;
    public static final int ALL_AS_LOCAL = 4;
    private String module;
    private File modFile;
    private Scanner input;
    private int type;
    private String prefix;

    public ImportInterpreter(String module, int type, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        this.module = module;
        this.type = type;
        this.vat = vat;
        this.fat = fat;
        this.modFile = new File(this.module);
        this.file = module;
        int lastSlash = module.lastIndexOf(47);
        this.prefix = String.valueOf(module.substring(lastSlash + 1, module.length() - 4)) + ".";
        this.input = new Scanner(module);
        try {
            this.input = new Scanner(this.modFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.code = this.input.useDelimiter("\\Z").next();
        this.run_code = this.code.split("\\n");
    }

    @Override
    public void run() {
        String curr = "";
        String trimmed = "";
        int line = 0;
        try {
            line = 0;
            while (line < this.run_code.length) {
                curr = ImportInterpreter.removeComments(this.run_code[line]);
                while (curr.endsWith("\\")) {
                    curr = curr.substring(0, curr.length() - 1);
                    curr = String.valueOf(curr) + ImportInterpreter.removeComments(this.run_code[++line]);
                }
                trimmed = curr.trim();
                ImportInterpreter.removeWhitespace(trimmed);
                if (!trimmed.equals("") && (trimmed.startsWith("function ") || trimmed.startsWith("global function ") || trimmed.startsWith("native function ") || trimmed.startsWith("global native function ") || trimmed.startsWith("native global function "))) {
                    switch (this.type) {
                        case 0: {
                            line += this.makeFunction(trimmed, this.getBlock(line), this.prefix);
                            break;
                        }
                        case 1: {
                            if (!trimmed.startsWith("global ") && !trimmed.startsWith("native global ")) break;
                            line += this.makeFunction(trimmed, this.getBlock(line), this.prefix);
                            break;
                        }
                        case 2: {
                            if (!trimmed.startsWith("global ") && !trimmed.startsWith("native global")) {
                                trimmed = "global " + trimmed;
                            }
                            line += this.makeFunction(trimmed, this.getBlock(line), this.prefix);
                            break;
                        }
                        case 3: {
                            if (trimmed.startsWith("global ") || trimmed.startsWith("native global")) break;
                            line += this.makeFunction(trimmed, this.getBlock(line), this.prefix);
                            break;
                        }
                        case 4: {
                            if (trimmed.startsWith("global ")) {
                                trimmed = trimmed.substring(7);
                            }
                            if (trimmed.startsWith("native global")) {
                                trimmed = "native " + trimmed.substring(14);
                            }
                            line += this.makeFunction(trimmed, this.getBlock(line), this.prefix);
                        }
                    }
                }
                ++line;
            }
        }
        catch (PhoenixRuntimeException e) {
            this.dealWithError(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

