/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.scheinerman.phoenix.interpreter.CatchInterpreter;
import net.scheinerman.phoenix.interpreter.Condition;
import net.scheinerman.phoenix.interpreter.DoWhileInterpreter;
import net.scheinerman.phoenix.interpreter.ForInterpreter;
import net.scheinerman.phoenix.interpreter.IfInterpreter;
import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.SwitchInterpreter;
import net.scheinerman.phoenix.interpreter.TryInterpreter;
import net.scheinerman.phoenix.interpreter.WhileInterpreter;
import net.scheinerman.phoenix.interpreter.exceptions.IllegalIdentifierException;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.functions.NativeFunction;
import net.scheinerman.phoenix.interpreter.parser.Parser;
import net.scheinerman.phoenix.interpreter.variables.AbstractVariable;
import net.scheinerman.phoenix.interpreter.variables.FunctionVariable;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    protected String file;
    private boolean topLevel;
    protected boolean retTypeSet = false;
    protected Variable retType = null;
    protected Variable retValue = null;
    protected boolean printValues = false;
    protected int breakValue = 0;
    protected boolean _break = false;
    protected boolean _continue = false;
    protected boolean _return = false;
    protected boolean stop = false;
    protected int line = 0;
    protected int line_diff = 0;
    protected String code;
    protected String[] run_code;
    protected LinkedList<HashMap<String, Variable>> vat;
    protected LinkedList<HashMap<String, Function>> fat;
    public HashSet<String> keywordList = new HashSet();
    private Pattern identPattern = Pattern.compile("[\\p{Alnum}_]+");

    public Interpreter() {
        this.topLevel = true;
        this.initNewTables();
        this.initKeywordList();
    }

    public Interpreter(boolean topLevel, String file, String code, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        this(topLevel, file, code, 0, vat, fat);
    }

    public Interpreter(boolean topLevel, String file, String code, int line, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        this.topLevel = topLevel;
        this.file = file;
        this.code = code;
        this.run_code = this.code.split("\\n");
        this.line_diff = line;
        this.vat = vat;
        this.fat = fat;
        this.initNewTables();
        this.initKeywordList();
    }

    private final void initKeywordList() {
        this.keywordList.add("all");
        this.keywordList.add("break");
        this.keywordList.add("case");
        this.keywordList.add("const");
        this.keywordList.add("catch");
        this.keywordList.add("continue");
        this.keywordList.add("default");
        this.keywordList.add("delete");
        this.keywordList.add("do");
        this.keywordList.add("else");
        this.keywordList.add("for");
        this.keywordList.add("function");
        this.keywordList.add("global");
        this.keywordList.add("if");
        this.keywordList.add("local");
        this.keywordList.add("native");
        this.keywordList.add("num");
        this.keywordList.add("return");
        this.keywordList.add("str");
        this.keywordList.add("switch");
        this.keywordList.add("throw");
        this.keywordList.add("try");
        this.keywordList.add("void");
        this.keywordList.add("while");
    }

    protected final void initNewTables() {
        HashMap curr_vat = new HashMap();
        HashMap curr_fat = new HashMap();
        if (this.vat == null) {
            this.vat = new LinkedList();
        }
        if (this.fat == null) {
            this.fat = new LinkedList();
        }
        this.vat.addFirst(curr_vat);
        this.fat.addFirst(curr_fat);
    }

    public void run() {
        this.doRun();
        this.vat.remove();
        this.fat.remove();
    }

    protected void doRun() {
        String curr = "";
        String trimmed = "";
        this.line = 0;
        try {
            this.line = 0;
            while (this.line < this.run_code.length) {
                if (!this.stop) {
                    curr = Interpreter.removeComments(this.run_code[this.line]);
                    trimmed = curr.trim();
                    Interpreter.removeWhitespace(trimmed);
                    if (!trimmed.equals("")) {
                        if (trimmed.startsWith("function ") || trimmed.startsWith("global function ") || trimmed.startsWith("native function ") || trimmed.startsWith("global native function ") || trimmed.startsWith("native global function ") || trimmed.startsWith("local function ") || trimmed.startsWith("local native function ") || trimmed.startsWith("native local function ")) {
                            this.line += this.makeFunction(trimmed, this.getBlock(this.line), null) - 1;
                        } else if (trimmed.startsWith("const global num ") || trimmed.startsWith("const global str ") || trimmed.startsWith("global const num ") || trimmed.startsWith("global const str ") || trimmed.startsWith("const local num ") || trimmed.startsWith("const local str ") || trimmed.startsWith("local const num ") || trimmed.startsWith("local const str ") || trimmed.startsWith("local num ") || trimmed.startsWith("local str ") || trimmed.startsWith("const num ") || trimmed.startsWith("const str ") || trimmed.startsWith("global num ") || trimmed.startsWith("global str ") || trimmed.startsWith("const num ") || trimmed.startsWith("const str ") || trimmed.startsWith("num ") || trimmed.startsWith("str ")) {
                            this.makeVariable(trimmed);
                        } else if (trimmed.equals("break") || trimmed.startsWith("break ")) {
                            this._break(trimmed);
                        } else {
                            if (trimmed.matches("case\\s*:")) {
                                throw new SyntaxException("Case statements can only be inside switch blocks.");
                            }
                            if (trimmed.matches("catch\\s*:")) {
                                throw new SyntaxException("Catch blocks must follow try blocks.");
                            }
                            if (trimmed.equals("continue")) {
                                this.line = this._continue(this.line);
                            } else if (trimmed.startsWith("delete ")) {
                                String identifier = trimmed.substring(7);
                                if (!this.delete(identifier)) {
                                    throw new SyntaxException("No such variable or function.");
                                }
                            } else if (trimmed.matches("do\\s*:")) {
                                this.line = this._do(trimmed, this.line);
                            } else if (trimmed.startsWith("for ")) {
                                this.line = this._for(trimmed, this.line);
                            } else if (trimmed.startsWith("if ")) {
                                this.line = this._if(trimmed, this.line);
                            } else if (trimmed.equals("return") || trimmed.startsWith("return ")) {
                                this.line = this._return(trimmed, this.line);
                            } else if (trimmed.startsWith("switch ")) {
                                this.line = this._switch(trimmed, this.line);
                            } else if (trimmed.startsWith("throw ")) {
                                this._throw(trimmed);
                            } else if (trimmed.matches("try\\s*:")) {
                                this.line = this._try(this.line);
                            } else if (trimmed.startsWith("while ")) {
                                this.line = this._while(trimmed, this.line);
                            } else {
                                if (trimmed.equals("<bug>")) {
                                    throw new Exception("Example bug");
                                }
                                Variable v = this.parsePhrase(trimmed);
                                if (v != null && this.printValues) {
                                    if (v instanceof StringVariable) {
                                        InterpreterData.printlnOut("  = \"" + v.toString() + "\"");
                                    } else {
                                        InterpreterData.printlnOut("  = " + v.toString());
                                    }
                                }
                            }
                        }
                    }
                    ++this.line;
                    continue;
                }
                break;
            }
        }
        catch (PhoenixRuntimeException e) {
            this.dealWithError(e);
            return;
        }
        catch (Exception e) {
            InterpreterData.printlnErr("An internal error occurred. Please report the incident to:\n<phoenix.programming.language@gmail.com>. In the email please\nattach the code being run and the complete output of the code\nincluding the following stack trace: \n");
            e.printStackTrace();
            InterpreterData.printlnErr("\nThank you for helping to fix this bug!");
            System.exit(0);
            return;
        }
    }

    protected void dealWithError(PhoenixRuntimeException e) {
        InterpreterData.ERROR = e;
        int tempLine = this.line + 1 + this.line_diff;
        if (!e.isLastLineSet()) {
            e.setLastLine(tempLine);
            e.setLastLineSet(true);
        } else if (e.isLastLineSet()) {
            tempLine = e.getLastLine();
        }
        String fileInfo = " (File:" + this.file + ", Line:" + tempLine + ")";
        if (this instanceof Function) {
            InterpreterData.ERROR_TRACE.add("... in function " + ((Function)this).getName() + fileInfo);
            if (!InterpreterData.ERROR_TRACE_STARTED) {
                InterpreterData.ERROR_TRACE_STARTED = true;
            }
            e.setLastLineSet(false);
            throw e;
        }
        if (this.topLevel) {
            InterpreterData.ERROR_TRACE.add("... in main scope" + fileInfo);
            e.printErrorMessage();
            if (e.getErrorType().equals("Nincompoop error")) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        } else {
            throw e;
        }
    }

    protected boolean retValueMatches() {
        return (this.retType != null || this.retValue == null) && (this.retValue == null || this.retType.getType().equals(this.retValue.getType()));
    }

    public final void putFunction(Function f, HashMap<String, Function> hm) {
        if (!this.isValidIdentifier(f.getName())) {
            throw new IllegalIdentifierException(f.getName());
        }
        hm.put(f.getName(), f);
    }

    public static final String removeComments(String line) {
        String temp = line;
        if (line.indexOf("//") != -1) {
            temp = temp.replaceAll("//.+", "");
        }
        temp = temp.replaceAll("/\\*.+\\*/", "");
        return temp;
    }

    public final Variable parsePhrase(String phrase) {
        try {
            return Parser.parse(phrase, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!(e instanceof PhoenixRuntimeException)) {
                throw new SyntaxException("Could not parse expression.");
            }
            throw new PhoenixRuntimeException((PhoenixRuntimeException)e);
        }
    }

    private void _break(String code) {
        if (code.equals("break all windows")) {
            try {
                InputStream in = this.getClass().getResourceAsStream("glass_break.wav");
                AudioStream as = new AudioStream(in);
                AudioPlayer.player.start((InputStream)as);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw new PhoenixRuntimeException(){
                private static final long serialVersionUID = 1L;

                public String getErrorType() {
                    return "Nincompoop error";
                }

                public String getBriefMessage() {
                    return "Great, now look what you've done!";
                }
            };
        }
        Variable var = code.equals("break all") ? new NumberVariable(InterpreterData.LOOPS) : (code.equals("break") ? new NumberVariable(1.0) : this.parsePhrase(code.substring(6)));
        if (var == null) {
            throw new SyntaxException("Must include a number after a break statement");
        }
        if (var instanceof StringVariable) {
            throw new SyntaxException("Variable following break must be number");
        }
        int value = (int)((NumberVariable)var).value();
        this.dealWithBreak(value);
    }

    private int _continue(int line) {
        return this.dealWithContinue(line);
    }

    private int _do(String code, int line) {
        String block = this.getBlock(line);
        int endLine = line + block.split("\\n").length - 1;
        String end = Interpreter.removeComments(this.run_code[endLine + 1]).trim();
        Interpreter.removeWhitespace(end);
        if (!end.startsWith("while ")) {
            throw new SyntaxException("Do block must end with a while statement.");
        }
        String whileStatement = end.substring(6);
        if (whileStatement.matches("\\s*")) {
            throw new SyntaxException("The while statement cannot be empty.");
        }
        DoWhileInterpreter interpreter = new DoWhileInterpreter(this.file, block, line + this.line_diff + 1, whileStatement, this.vat, this.fat);
        interpreter.run();
        if (interpreter._break) {
            this.dealWithBreak(interpreter.breakValue);
        }
        if (interpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (interpreter._return) {
            this.dealWithReturn(interpreter.retValue);
        }
        line = endLine + 1;
        return line;
    }

    private int _for(String code, int line) {
        if (!code.endsWith(":")) {
            throw new SyntaxException("For statement must end with a colon.");
        }
        String block = this.getBlock(line);
        String statement = code.substring(4, code.length() - 1);
        ForInterpreter interpreter = new ForInterpreter(this.file, block, line + this.line_diff + 1, statement, this.vat, this.fat);
        interpreter.run();
        if (interpreter._break) {
            this.dealWithBreak(interpreter.breakValue);
        }
        if (interpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (interpreter._return) {
            this.dealWithReturn(interpreter.retValue);
        }
        return line += block.split("\\n").length - 1;
    }

    private int _if(String code, int line) {
        if (!code.endsWith(":")) {
            throw new SyntaxException("If statement must end with a colon.");
        }
        String statement = code.substring(3, code.length() - 1);
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        int currLine = line;
        boolean done = false;
        while (true) {
            if (statement.matches("\\s*")) {
                throw new SyntaxException("The if/else statement cannot be empty.");
            }
            String block = this.getBlock(currLine);
            Condition c = new Condition(statement, block, currLine + this.line_diff + 1);
            conditions.add(c);
            if (done || (currLine += block.split("\n").length) == this.run_code.length) break;
            String next = Interpreter.removeComments(this.run_code[currLine]).trim();
            Interpreter.removeWhitespace(next);
            if (next.startsWith("else if ")) {
                if (!next.endsWith(":")) {
                    throw new SyntaxException("Else if statement must end with a colon.");
                }
                statement = next.substring(8, next.length() - 1);
                continue;
            }
            if (!next.matches("else.*:")) break;
            statement = "1";
            done = true;
        }
        IfInterpreter interpreter = new IfInterpreter(this.file, conditions, this, this.vat, this.fat);
        interpreter.run();
        if (interpreter._break) {
            this.dealWithBreak(interpreter.breakValue);
        }
        if (interpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (interpreter._return) {
            this.dealWithReturn(interpreter.retValue);
        }
        line = currLine - 1;
        return line;
    }

    private int _return(String code, int line) {
        this.retValue = code.length() == 6 ? null : this.parsePhrase(code.substring(6));
        this.dealWithReturn(this.retValue);
        return line;
    }

    private int _switch(String code, int line) {
        if (!code.endsWith(":")) {
            throw new SyntaxException("Switch statement must end with a colon.");
        }
        Variable switchVariable = this.parsePhrase(code.substring(7, code.length() - 1));
        String block = this.getBlock(line);
        SwitchInterpreter interpreter = new SwitchInterpreter(this.file, block, line + this.line_diff + 1, switchVariable, this.vat, this.fat);
        interpreter.run();
        if (interpreter._break) {
            this.dealWithBreak(interpreter.breakValue);
        }
        if (interpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (interpreter._return) {
            this.dealWithReturn(interpreter.retValue);
        }
        return line += block.split("\\n").length - 1;
    }

    private void _throw(String code) {
        Variable errorMessage = this.parsePhrase(code.substring(6));
        if (!(errorMessage instanceof StringVariable)) {
            throw new SyntaxException("Throw statement must include a string.");
        }
        throw new PhoenixRuntimeException("Error", ((StringVariable)errorMessage).value());
    }

    private int _try(int line) {
        String tryBlock = this.getBlock(line);
        int catchLine = line + tryBlock.split("\n").length;
        String catchStatement = Interpreter.removeComments(this.run_code[catchLine]).trim();
        Interpreter.removeWhitespace(catchStatement);
        if (!catchStatement.matches("catch\\s*:")) {
            throw new SyntaxException("Try block must be followed by a catch block.");
        }
        String catchBlock = this.getBlock(catchLine);
        CatchInterpreter catchInterpreter = new CatchInterpreter(this.file, catchBlock, catchLine + this.line_diff + 1, this.vat, this.fat);
        TryInterpreter tryInterpreter = new TryInterpreter(this.file, tryBlock, line + this.line_diff + 1, this.vat, this.fat, catchInterpreter);
        tryInterpreter.run();
        if (tryInterpreter._break) {
            this.dealWithBreak(tryInterpreter.breakValue);
        }
        if (tryInterpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (tryInterpreter._return) {
            this.dealWithReturn(tryInterpreter.retValue);
        }
        int endLine = catchLine + catchBlock.split("\n").length - 1;
        return endLine;
    }

    private int _while(String trimmed, int line) {
        if (!trimmed.endsWith(":")) {
            throw new SyntaxException("While statement must end with a colon.");
        }
        String block = this.getBlock(line);
        String statement = trimmed.substring(6, trimmed.length() - 1);
        if (statement.matches("\\s*")) {
            throw new SyntaxException("The while statement cannot be empty.");
        }
        WhileInterpreter interpreter = new WhileInterpreter(this.file, block, line + this.line_diff + 1, statement, this.vat, this.fat);
        interpreter.run();
        if (interpreter._break) {
            this.dealWithBreak(interpreter.breakValue);
        }
        if (interpreter._continue) {
            return this.dealWithContinue(line);
        }
        if (interpreter._return) {
            this.dealWithReturn(interpreter.retValue);
        }
        return line += block.split("\\n").length - 1;
    }

    protected void dealWithBreak(int value) {
        if (this.topLevel) {
            throw new SyntaxException("A break can only be used within a case block or loop.");
        }
        if (value <= 0) {
            throw new SyntaxException("Break value must be an integer greater than 0.");
        }
        this.breakValue = value;
        this._break = true;
        this.stop = true;
    }

    protected int dealWithContinue(int line) {
        if (this.topLevel) {
            throw new SyntaxException("A continue can only be used within a loop.");
        }
        this._continue = true;
        this.stop = true;
        return line;
    }

    protected void dealWithReturn(Variable passed) {
        if (this.topLevel) {
            throw new SyntaxException("A return can only be used within a function.");
        }
        this.retValue = passed;
        this._return = true;
        this.stop = true;
    }

    public final String getBlock(int start) {
        int base = Interpreter.getWhitespace(this.run_code[start]);
        int curr = start + 1;
        String code = "";
        while (curr < this.run_code.length && (this.run_code[curr].trim().equals("") || Interpreter.getWhitespace(this.run_code[curr]) > base)) {
            code = String.valueOf(code) + this.run_code[curr++] + "\n";
        }
        return String.valueOf(code) + " ";
    }

    public final int makeFunction(String line, String code, String prefix) {
        LinkedList<HashMap<String, Function>> temp_fat;
        String s;
        boolean global = false;
        boolean nat = false;
        while (line.startsWith("global") || line.startsWith("native") || line.startsWith("local")) {
            if (line.startsWith("global")) {
                line = line.substring(7);
                global = true;
            }
            if (line.startsWith("native")) {
                line = line.substring(7);
                nat = true;
            }
            if (!line.startsWith("local")) continue;
            line = line.substring(7);
        }
        String modifiers = (global ? "global " : "") + (nat ? "native " : "");
        if (!line.endsWith(":")) {
            throw new SyntaxException("Function declaration must end with a colon.");
        }
        line = line.substring(0, line.lastIndexOf(58));
        Function f = this.getFunctionFromDefinition(line, code, nat, true);
        TreeSet<String> names = new TreeSet<String>();
        String[] stringArray = f.getBeforeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals("")) {
                throw new SyntaxException("Must provide names for function arguments.");
            }
            if (!s.matches(this.identPattern.pattern())) {
                throw new SyntaxException("Illegal argument name, '" + s + "'.");
            }
            if (!names.add(s)) {
                throw new SyntaxException("Cannot repeat function argument names.");
            }
            ++n2;
        }
        stringArray = f.getAfterNames();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals("")) {
                throw new SyntaxException("Must provide names for function arguments.");
            }
            if (!s.matches(this.identPattern.pattern())) {
                throw new SyntaxException("Illegal argument name, '" + s + "'.");
            }
            if (!names.add(s)) {
                throw new SyntaxException("Cannot repeat function argument names.");
            }
            ++n2;
        }
        f.setModifiers(modifiers);
        LinkedList<HashMap<String, Variable>> temp_vat = new LinkedList<HashMap<String, Variable>>();
        temp_vat.add(this.vat.getLast());
        if (global) {
            temp_fat = new LinkedList();
            temp_fat.add(this.fat.getLast());
        } else {
            temp_fat = this.fat;
        }
        f.setVATandFAT(temp_vat, temp_fat);
        if (global) {
            this.putFunction(f, this.fat.getLast());
        } else {
            this.putFunction(f, this.fat.getFirst());
        }
        if (!code.trim().equals(code)) {
            return code.split("[\\n]").length;
        }
        return 0;
    }

    public final Function getFunctionFromDefinition(String line, String code, boolean nat, boolean setupDocs) {
        Variable[] b4_types = new Variable[]{};
        String[] b4_names = new String[]{};
        Variable[] af_types = new Variable[]{};
        String[] af_names = new String[]{};
        String left = null;
        String right = null;
        String[] tempParts = (line = line.substring(8).trim()).split("\\s+");
        Variable retType = Interpreter.makeDefaultVariable(tempParts[0]);
        if (retType != null && nat) {
            throw new SyntaxException("Native functions must have void return type.");
        }
        if ((line = line.substring(tempParts[0].length()).trim()).startsWith("(")) {
            int index;
            block8: {
                int parens = 0;
                index = 0;
                while (true) {
                    int index2;
                    char c;
                    if ((c = line.charAt(index)) == '(') {
                        ++parens;
                    } else if (c == ')') {
                        --parens;
                    }
                    if (parens == 0) break block8;
                    int index1 = line.indexOf(40, index + 1);
                    if (index1 < (index2 = line.indexOf(41, index + 1)) && index1 != -1) {
                        index = index1;
                        continue;
                    }
                    if (index2 == -1) break;
                    index = index2;
                }
                throw new SyntaxException("Bad function format.");
            }
            left = line.substring(1, index);
            line = line.substring(index + 1).trim();
            Object[][] temp = this.getFunctionArguments(left);
            b4_types = (Variable[])temp[0];
            b4_names = (String[])temp[1];
        }
        int oparen = line.indexOf(40);
        String name = line;
        if (oparen != -1) {
            name = name.substring(0, oparen);
            right = line.substring(oparen);
            right = right.substring(1, right.length() - 1);
            Object[][] temp = this.getFunctionArguments(right);
            af_types = (Variable[])temp[0];
            af_names = (String[])temp[1];
        }
        name = name.trim();
        Function function = nat ? new NativeFunction(name, code, b4_types, b4_names, af_types, af_names) : new Function(name, this.file, code, this.line + 1 + this.line_diff, b4_types, b4_names, af_types, af_names, retType, setupDocs);
        return function;
    }

    public final void makeVariable(String code) {
        boolean global = false;
        boolean constant = false;
        if (code.startsWith("const global") || code.startsWith("global const")) {
            code = code.substring(13);
            constant = true;
            global = true;
        }
        if (code.startsWith("local const") || code.startsWith("const local")) {
            code = code.substring(12);
            constant = true;
        }
        if (code.startsWith("global")) {
            code = code.substring(7);
            global = true;
        }
        if (code.startsWith("local")) {
            code = code.substring(6);
        }
        if (code.startsWith("const")) {
            code = code.substring(6);
            constant = true;
        }
        int e_pos = code.indexOf(61);
        String name = "";
        boolean just_instantiation = true;
        String type = code.split("\\s+")[0].trim();
        if (e_pos >= 0) {
            name = code.substring(4, e_pos).trim();
            just_instantiation = false;
        } else {
            name = code.substring(4).trim();
        }
        if (!this.isValidIdentifier(name)) {
            throw new IllegalIdentifierException(name);
        }
        if (just_instantiation) {
            Variable var = Interpreter.makeDefaultVariable(type);
            var.setConstant(constant);
            if (global) {
                this.vat.getLast().put(name, var);
            } else {
                this.vat.getFirst().put(name, var);
            }
            return;
        }
        Variable var = this.makeVariable(type, this.parsePhrase(code.substring(e_pos + 1)));
        var.setConstant(constant);
        if (global) {
            this.vat.getLast().put(name, var);
        } else {
            this.vat.getFirst().put(name, var);
        }
    }

    public final Variable makeVariable(String type, Variable value) {
        Variable retVal = Interpreter.makeDefaultVariable(type);
        retVal.assign(value);
        return retVal;
    }

    public static final Variable makeDefaultVariable(String type) {
        if (type.equals("num")) {
            return new NumberVariable(0.0);
        }
        if (type.equals("str")) {
            return new StringVariable("");
        }
        if (type.equals("void")) {
            return null;
        }
        throw new SyntaxException("Unknown type \"" + type + "\"");
    }

    public final boolean isValidIdentifier(String identifier) {
        if (!this.identPattern.matcher(identifier).matches()) {
            return false;
        }
        if (this.keywordList.contains(identifier)) {
            return false;
        }
        if (this.getVariable(identifier) != null) {
            return false;
        }
        return this.getFunction(identifier) == null;
    }

    public final Function getFunction(String identifier) {
        for (HashMap hashMap : this.fat) {
            if (!hashMap.containsKey(identifier)) continue;
            return (Function)hashMap.get(identifier);
        }
        return null;
    }

    public final Variable getVariable(String identifier) {
        for (HashMap hashMap : this.vat) {
            if (!hashMap.containsKey(identifier)) continue;
            return (Variable)hashMap.get(identifier);
        }
        return null;
    }

    public final boolean delete(String identifier) {
        for (HashMap hashMap : this.fat) {
            if (!hashMap.containsKey(identifier)) continue;
            hashMap.remove(identifier);
            return true;
        }
        for (HashMap hashMap : this.vat) {
            if (!hashMap.containsKey(identifier)) continue;
            hashMap.remove(identifier);
            return true;
        }
        return false;
    }

    public final Object[][] getFunctionArguments(String line) {
        LinkedList<AbstractVariable> types = new LinkedList<AbstractVariable>();
        LinkedList<String> names = new LinkedList<String>();
        line = String.valueOf(line) + ",";
        int index = 0;
        while (index < line.length() - 1 && index >= 0) {
            line = line.substring(index).trim();
            int comma = line.indexOf(44);
            if (line.matches("num\\s+\\S+\\s*,.*")) {
                types.add(new NumberVariable());
                names.add(line.substring(3, comma).trim());
                index = comma + 1;
                continue;
            }
            if (line.matches("str\\s+\\S+\\s*,.*")) {
                types.add(new StringVariable());
                names.add(line.substring(3, comma).trim());
                index = comma + 1;
                continue;
            }
            if (line.startsWith("function ")) {
                index = 0;
                comma = line.indexOf(44);
                int oparen = line.indexOf(40);
                if (oparen == -1) {
                    index = comma;
                } else if (oparen < comma || oparen > comma) {
                    int tempCparen;
                    int tempOparen;
                    int parens = 0;
                    int tempIndex = oparen;
                    while (tempIndex < line.length() && tempIndex >= 0) {
                        if (line.charAt(tempIndex) == '(') {
                            ++parens;
                        }
                        if (line.charAt(tempIndex) == ')') {
                            --parens;
                        }
                        if (parens == 0) break;
                        tempOparen = line.indexOf(40, tempIndex + 1);
                        tempIndex = tempOparen < (tempCparen = line.indexOf(41, tempIndex + 1)) && tempOparen != -1 ? tempOparen : tempCparen;
                    }
                    index = tempIndex + 1;
                    comma = line.indexOf(",", index);
                    oparen = line.indexOf("(", index);
                    if (oparen == -1 || oparen > comma) {
                        index = comma;
                    } else if (oparen < comma) {
                        parens = 0;
                        tempIndex = oparen;
                        while (tempIndex < line.length() && tempIndex >= 0) {
                            if (line.charAt(tempIndex) == '(') {
                                ++parens;
                            }
                            if (line.charAt(tempIndex) == ')') {
                                --parens;
                            }
                            if (parens == 0) break;
                            tempOparen = line.indexOf(40, tempIndex + 1);
                            tempIndex = tempOparen < (tempCparen = line.indexOf(41, tempIndex + 1)) && tempOparen != -1 ? tempOparen : tempCparen;
                        }
                        index = tempIndex + 1;
                    }
                }
                Function f = this.getFunctionFromDefinition(line.substring(0, index), "", false, false);
                types.add(new FunctionVariable(f));
                names.add(f.getName());
                ++index;
                continue;
            }
            throw new SyntaxException("Bad function argument (" + line + ")");
        }
        Variable[] arg_types = types.toArray(new Variable[types.size()]);
        String[] arg_names = names.toArray(new String[names.size()]);
        Object[][] rVal = new Object[][]{arg_types, arg_names};
        return rVal;
    }

    public static final int getWhitespace(String line) {
        if (line.matches("\\S+.*")) {
            return -1;
        }
        int index = 0;
        while (line.substring(index, index + 1).matches("\\s")) {
            ++index;
        }
        return index;
    }

    public static final void removeWhitespace(String code) {
        String[] parts = code.split("\"");
        code = "";
        int index = 0;
        while (index < parts.length) {
            String s = parts[index];
            code = index % 2 == 0 ? String.valueOf(code) + s.replaceAll("\\s+", " ") + '\"' : String.valueOf(code) + s + '\"';
            ++index;
        }
        code = code.substring(0, code.length() - 1);
    }

    public final Variable getReturnValue() {
        return this.retValue;
    }
}

