/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoopInterpreter
extends Interpreter {
    private boolean run = false;

    public LoopInterpreter(String file, String code, int line, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        super(false, file, code, line, vat, fat);
    }

    @Override
    public final void run() {
        if (!this.run) {
            this.beforeStart();
            ++InterpreterData.LOOPS;
            while (!this.isDone() && !this.stop) {
                this.vat.removeFirst();
                this.fat.removeFirst();
                this.initNewTables();
                this.doRun();
            }
            this.run = true;
            --InterpreterData.LOOPS;
            this.afterEnd();
        }
        this.vat.removeFirst();
        this.fat.removeFirst();
    }

    @Override
    protected void dealWithBreak(int value) {
        this.breakValue = value - 1;
        this._break = false;
        this.stop = true;
        if (this.breakValue > 0) {
            this._break = true;
        }
    }

    @Override
    protected int dealWithContinue(int line) {
        this._continue = false;
        return this.run_code.length;
    }

    protected boolean isDone() {
        return false;
    }

    protected void beforeStart() {
    }

    protected void afterEnd() {
    }
}

