/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchInterpreter
extends Interpreter {
    private boolean fallThrough = false;
    private Variable switchVariable = null;

    public SwitchInterpreter(String file, String code, int line, Variable switchVariable, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        super(false, file, code, vat, fat);
        this.switchVariable = switchVariable;
        if (switchVariable.isLiteral()) {
            throw new SyntaxException("Cannot switch on a literal variable.");
        }
        this.line_diff += line;
    }

    @Override
    public final void doRun() {
        String curr = "";
        String trimmed = "";
        int line = 0;
        try {
            line = 0;
            while (line < this.run_code.length) {
                if (!this.stop) {
                    curr = SwitchInterpreter.removeComments(this.run_code[line]);
                    trimmed = curr.trim();
                    SwitchInterpreter.removeWhitespace(trimmed);
                    if (!trimmed.equals("")) {
                        if (trimmed.startsWith("case ")) {
                            if (!trimmed.endsWith(":")) {
                                throw new SyntaxException("Case statements must end with a colon.");
                            }
                            String strVal = trimmed.substring(5, trimmed.length() - 1);
                            Variable value = this.parsePhrase(strVal);
                            String block = this.getBlock(line);
                            if (this.fallThrough || ((NumberVariable)value.isEqualTo(this.switchVariable)).value() == 1.0) {
                                Interpreter interpreter = new Interpreter(false, this.file, block, line, this.vat, this.fat);
                                interpreter.run();
                                this.fallThrough = true;
                                if (interpreter._break) {
                                    this.dealWithBreak(interpreter.breakValue);
                                }
                            }
                            if (!block.trim().equals("")) {
                                line += block.split("\\n").length - 1;
                            }
                        } else if (trimmed.replaceAll("\\s+", "").equals("default:")) {
                            String block = this.getBlock(line);
                            Interpreter interpreter = new Interpreter(false, this.file, block, line, this.vat, this.fat);
                            interpreter.run();
                            line += block.split("\\n").length;
                        } else {
                            throw new SyntaxException("Switch blocks can only contain case/default blocks.");
                        }
                    }
                    ++line;
                    continue;
                }
                break;
            }
        }
        catch (PhoenixRuntimeException e) {
            this.dealWithError(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void dealWithBreak(int value) {
        this.breakValue = value - 1;
        this._break = false;
        this.stop = true;
        if (this.breakValue > 0) {
            this._break = true;
        }
    }
}

