/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter;

import java.util.HashMap;
import java.util.LinkedList;
import net.scheinerman.phoenix.interpreter.LoopInterpreter;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhileInterpreter
extends LoopInterpreter {
    protected String whileStatement;

    public WhileInterpreter(String file, String code, int line, String whileStatement, LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        super(file, code, line, vat, fat);
        this.whileStatement = whileStatement;
    }

    @Override
    protected boolean isDone() {
        Variable v = this.parsePhrase(this.whileStatement);
        if (!(v instanceof NumberVariable)) {
            throw new SyntaxException("While statement must return a number variable.");
        }
        NumberVariable nv = (NumberVariable)v;
        return nv.value() == 0.0;
    }
}

