/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.exceptions;

import net.scheinerman.phoenix.interpreter.InterpreterData;

public class PhoenixRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String errorType = "Error";
    private String briefMessage = "Generic error";
    private int lastLine = -1;
    private boolean lastLineSet = false;

    public PhoenixRuntimeException(PhoenixRuntimeException e) {
        this.errorType = e.getErrorType();
        this.briefMessage = e.getBriefMessage();
    }

    public PhoenixRuntimeException(String errorType, String briefMessage) {
        this.errorType = errorType;
        this.briefMessage = briefMessage;
    }

    public PhoenixRuntimeException() {
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getBriefMessage() {
        return this.briefMessage;
    }

    public void setLastLine(int lastLine) {
        this.lastLine = lastLine;
    }

    public int getLastLine() {
        return this.lastLine;
    }

    public void setLastLineSet(boolean lastLineSet) {
        this.lastLineSet = lastLineSet;
    }

    public boolean isLastLineSet() {
        return this.lastLineSet;
    }

    public final void printErrorMessage() {
        InterpreterData.printlnErr(String.valueOf(this.getErrorType()) + ": " + this.getBriefMessage());
        while (!InterpreterData.ERROR_TRACE.isEmpty()) {
            InterpreterData.printlnErr(InterpreterData.ERROR_TRACE.remove());
        }
    }
}

