/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.functions;

import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public abstract class BuiltInFunction
extends Function {
    public BuiltInFunction(String name, String retType, String[] left, String[] right, String[] leftNames, String[] rightNames) {
        this.name = name;
        this.retType = BuiltInFunction.makeDefaultVariable(retType);
        this.b4_types = this.convertStrToVar(left);
        this.af_types = this.convertStrToVar(right);
        this.b4_names = leftNames;
        this.af_names = rightNames;
        this.modifiers = "global ";
    }

    public BuiltInFunction(String prefix, String name, String retType, String[] left, String[] right, String[] leftNames, String[] rightNames) {
        this(String.valueOf(prefix) + "." + name, retType, left, right, leftNames, rightNames);
    }

    private Variable[] convertStrToVar(String[] args) {
        Variable[] output = new Variable[args.length];
        int index = 0;
        while (index < args.length) {
            output[index] = BuiltInFunction.makeDefaultVariable(args[index]);
            ++index;
        }
        return output;
    }

    private String[] convertVarToStr(Variable[] args) {
        String[] output = new String[args.length];
        int index = 0;
        while (index < args.length) {
            output[index] = args[index] instanceof StringVariable ? ((StringVariable)args[index]).value() : "" + ((NumberVariable)args[index]).value();
            ++index;
        }
        return output;
    }

    public final void run(Variable[] b4_args, Variable[] af_args) {
        this.run(this.convertVarToStr(b4_args), this.convertVarToStr(af_args));
    }

    public abstract void run(String[] var1, String[] var2);
}

