/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.functions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.variables.FunctionVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
extends Interpreter {
    protected String name;
    protected Variable[] b4_types;
    protected String[] b4_names;
    protected Variable[] af_types;
    protected String[] af_names;
    protected String description;
    protected TreeMap<String, String> argDescriptions = new TreeMap();
    protected String returnDescription;
    protected String modifiers = "";

    public Function() {
    }

    public Function(String name, String file, String code, int line, Variable[] b4_types, String[] b4_names, Variable[] af_types, String[] af_names, Variable retType, boolean setupDocs) {
        super(true, file, code, line, null, null);
        this.name = name;
        this.b4_types = b4_types;
        this.b4_names = b4_names;
        this.af_types = af_types;
        this.af_names = af_names;
        this.retType = retType;
        this.retTypeSet = true;
        int start = 0;
        while (start < this.run_code.length && this.run_code[start].trim().equals("")) {
            ++start;
        }
        if (setupDocs && this.run_code[start].trim().startsWith("///")) {
            int end = start;
            while (end < this.run_code.length && this.run_code[end].trim().startsWith("///")) {
                ++end;
            }
            String comments = "";
            int index = start;
            while (index < end) {
                comments = String.valueOf(comments) + " " + this.run_code[index].substring(4) + " ";
                ++index;
            }
            int atIndex = comments.indexOf(64);
            while (atIndex != -1) {
                int nextIndex = comments.indexOf(64, atIndex + 1);
                String section = nextIndex == -1 ? comments.substring(atIndex) : comments.substring(atIndex, nextIndex);
                if ((section = section.replaceAll("\\s+", " ")).startsWith("@desc ")) {
                    this.description = section.substring(6);
                } else if (section.startsWith("@arg ")) {
                    int space = section.indexOf(32, 5);
                    this.argDescriptions.put(section.substring(5, space), section.substring(space + 1));
                } else if (section.startsWith("@return ")) {
                    this.returnDescription = section.substring(8);
                }
                atIndex = nextIndex;
            }
        }
    }

    public void setVATandFAT(LinkedList<HashMap<String, Variable>> vat, LinkedList<HashMap<String, Function>> fat) {
        this.vat = vat;
        this.fat = fat;
    }

    public String getName() {
        return this.name;
    }

    public void run(Variable[] b4_args, Variable[] af_args) {
        if (!this.check(b4_args, af_args)) {
            throw new SyntaxException("The arguments passed are not compatible with the function " + this.name + ".");
        }
        this.addArgs(b4_args, af_args);
        this.stop = false;
        this.retValue = null;
        this._return = false;
        this.doRun();
        if (this.retValue == null && this.retType != null) {
            throw new SyntaxException("Function " + this.name + " must return a variable of type " + this.retType.getType() + ".");
        }
        this.vat.remove();
        this.fat.remove();
    }

    @Override
    protected void dealWithReturn(Variable passed) {
        this._return = false;
        this.stop = true;
        this.retValue = passed;
        if (this.retTypeSet && !this.retValueMatches()) {
            throw new SyntaxException("Return value must match the specified type.");
        }
    }

    protected boolean check(Variable[] b4_args, Variable[] af_args) {
        if (b4_args.length != this.b4_types.length || af_args.length != this.af_types.length) {
            return false;
        }
        int i = 0;
        while (i < this.b4_types.length) {
            if (!b4_args[i].getClass().getName().equals(this.b4_types[i].getClass().getName())) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.af_types.length) {
            if (!af_args[i].getClass().getName().equals(this.af_types[i].getClass().getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void addArgs(Variable[] b4_args, Variable[] af_args) {
        HashMap<String, Variable> curr_vat = new HashMap<String, Variable>();
        HashMap<String, Function> curr_fat = new HashMap<String, Function>();
        int i = 0;
        while (i < this.b4_names.length) {
            if (b4_args[i] instanceof FunctionVariable) {
                curr_fat.put(this.b4_names[i], ((FunctionVariable)b4_args[i]).getFunction());
            } else {
                curr_vat.put(this.b4_names[i], b4_args[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.af_names.length) {
            if (af_args[i] instanceof FunctionVariable) {
                curr_fat.put(this.af_names[i], ((FunctionVariable)af_args[i]).getFunction());
            } else {
                curr_vat.put(this.af_names[i], af_args[i]);
            }
            ++i;
        }
        this.vat.addFirst(curr_vat);
        this.fat.addFirst(curr_fat);
    }

    public Variable[] getBeforeTypes() {
        return this.b4_types;
    }

    public Variable[] getAfterTypes() {
        return this.af_types;
    }

    public String[] getBeforeNames() {
        return this.b4_names;
    }

    public String[] getAfterNames() {
        return this.af_names;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        Variable o;
        String rVal = "function " + this.retType.getType() + " (";
        Variable[] variableArray = this.b4_types;
        int n = this.b4_types.length;
        int n2 = 0;
        while (n2 < n) {
            o = variableArray[n2];
            rVal = o instanceof FunctionVariable ? String.valueOf(rVal) + ((FunctionVariable)o).getFunction() + "," : String.valueOf(rVal) + o.getType() + ",";
            ++n2;
        }
        if (rVal.endsWith(",")) {
            rVal = rVal.substring(0, rVal.length() - 1);
        }
        rVal = String.valueOf(rVal) + ") " + this.name + " (";
        variableArray = this.af_types;
        n = this.af_types.length;
        n2 = 0;
        while (n2 < n) {
            o = variableArray[n2];
            rVal = o instanceof FunctionVariable ? String.valueOf(rVal) + ((FunctionVariable)o).getFunction() + "," : String.valueOf(rVal) + o.getType() + ",";
            ++n2;
        }
        if (rVal.endsWith(",")) {
            rVal = rVal.substring(0, rVal.length() - 1);
        }
        rVal = String.valueOf(rVal) + ")";
        return rVal;
    }

    public void setModifiers(String modifiers) {
        this.modifiers = modifiers;
    }

    public String getDefinition() {
        int index;
        String def = String.valueOf(this.modifiers) + "function " + (this.retType == null ? "void" : this.retType.getType()) + " ";
        if (this.b4_types != null && this.b4_types.length != 0) {
            def = String.valueOf(def) + "( ";
            index = 0;
            while (index < this.b4_types.length) {
                def = this.b4_types[index] instanceof FunctionVariable ? String.valueOf(def) + ((FunctionVariable)this.b4_types[index]).getFunction().getDefinition() : String.valueOf(def) + this.b4_types[index].getType() + " " + this.b4_names[index];
                if (index < this.b4_types.length - 1) {
                    def = String.valueOf(def) + ", ";
                }
                ++index;
            }
            def = String.valueOf(def) + " ) ";
        }
        def = String.valueOf(def) + this.name;
        if (this.af_types != null && this.af_types.length != 0) {
            def = String.valueOf(def) + " ( ";
            index = 0;
            while (index < this.af_types.length) {
                def = this.af_types[index] instanceof FunctionVariable ? String.valueOf(def) + ((FunctionVariable)this.af_types[index]).getFunction().getDefinition() : String.valueOf(def) + this.af_types[index].getType() + " " + this.af_names[index];
                if (index < this.af_types.length - 1) {
                    def = String.valueOf(def) + ", ";
                }
                ++index;
            }
            def = String.valueOf(def) + " )";
        }
        return def;
    }

    public void printHelp() {
        InterpreterData.printlnOut("Definition:", "\u001b[1m");
        InterpreterData.printlnOut("    " + this.getDefinition() + "\n");
        if (this.description == null) {
            InterpreterData.printlnOut("No help available for this function", "\u001b[31m");
        } else {
            InterpreterData.printlnOut("Description:", "\u001b[1m");
            InterpreterData.printlnOut("    " + (this.description.equals("") ? "[No description available.]" : this.description) + "\n");
            if (this.argDescriptions.size() > 0) {
                String desc;
                String arg;
                InterpreterData.printlnOut("Arguments:", "\u001b[1m");
                String[] stringArray = this.b4_names;
                int n = this.b4_names.length;
                int n2 = 0;
                while (n2 < n) {
                    arg = stringArray[n2];
                    desc = this.argDescriptions.get(arg);
                    InterpreterData.printOut("    " + arg, "\u001b[1m");
                    InterpreterData.printlnOut(desc != null ? " - " + desc : "[No description available.]");
                    ++n2;
                }
                stringArray = this.af_names;
                n = this.af_names.length;
                n2 = 0;
                while (n2 < n) {
                    arg = stringArray[n2];
                    desc = this.argDescriptions.get(arg);
                    InterpreterData.printOut("    " + arg, "\u001b[1m");
                    InterpreterData.printlnOut(desc != null ? " - " + desc : "[No description available.]");
                    ++n2;
                }
                InterpreterData.printlnOut("");
            }
            if (this.retType != null) {
                InterpreterData.printlnOut("Returns:", "\u001b[1m");
                InterpreterData.printlnOut("    " + (this.returnDescription.equals("") ? "[No description available.]" : this.returnDescription));
                InterpreterData.printlnOut("");
            }
        }
    }
}

