/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.functions;

import java.io.IOException;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class NativeFunction
extends Function {
    private String path;
    private Variable[] types;
    private String[] names;

    public NativeFunction(String name, String path, Variable[] b4_types, String[] b4_names, Variable[] af_types, String[] af_names) {
        if (!path.startsWith("\"") || !path.endsWith("\"") || path.split("\\s").length > 1) {
            throw new SyntaxException("Invalid class name in native function declaration.");
        }
        this.name = name;
        this.path = path;
        this.b4_types = b4_types;
        this.b4_names = b4_names;
        this.af_types = af_types;
        this.af_names = af_names;
        this.retValue = null;
        this.types = new Variable[b4_types.length + af_types.length];
        this.names = new String[b4_names.length + af_names.length];
        int i = 0;
        while (i < b4_types.length) {
            this.types[i] = b4_types[i];
            this.names[i] = b4_names[i];
            ++i;
        }
        i = 0;
        while (i < af_types.length) {
            this.types[i] = b4_types[i + b4_types.length];
            this.names[i] = b4_names[i + b4_names.length];
            ++i;
        }
    }

    private static String getArgList(Variable[] b4_args, Variable[] af_args) {
        String retVal = "";
        int i = 0;
        while (i < b4_args.length) {
            retVal = b4_args[i].getType().equals("num") ? String.valueOf(retVal) + ((NumberVariable)b4_args[i]).value() + " " : String.valueOf(retVal) + "\"" + ((StringVariable)b4_args[i]).value() + "\" ";
            ++i;
        }
        i = 0;
        while (i < af_args.length) {
            retVal = af_args[i].getType().equals("num") ? String.valueOf(retVal) + ((NumberVariable)af_args[i]).value() + " " : String.valueOf(retVal) + "\"" + ((StringVariable)af_args[i]).value() + "\" ";
            ++i;
        }
        return retVal;
    }

    public void run(Variable[] b4_args, Variable[] af_args) {
        if (!this.check(b4_args, af_args)) {
            throw new SyntaxException();
        }
        try {
            Runtime.getRuntime().exec("java " + this.path + " " + NativeFunction.getArgList(b4_args, af_args));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

