/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.exceptions.UnknownFunctionException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.parser.ArgListNode;
import net.scheinerman.phoenix.interpreter.parser.DataNode;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AddOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AndOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignAddOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignDivideOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignExpOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignModOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignMultiplyOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignRoundOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.AssignSubtractOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.DivideOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.EqualOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.ExpOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.FunctionOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.FunctionReferenceOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.GreaterEqualOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.GreaterOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.LessEqualOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.LessOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.ModOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.MultiplyOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.NegationOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.NotEqualOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.NotOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OrOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.PostfixDecrementOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.PostfixIncrementOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.PrefixDecrementOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.PrefixIncrementOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.RoundOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.SubscriptSliceOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.SubtractOperatorNode;
import net.scheinerman.phoenix.interpreter.parser.operators.XOrOperatorNode;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static Interpreter interpreter;
    private static final String OPERATORS = "+&/=^<>%*!|#-(,[:@";

    public static Variable parse(String expression, Interpreter i) throws SyntaxException {
        interpreter = i;
        if (!Parser.parensMatch(expression)) {
            throw new SyntaxException("Parentheses and brackets do not match");
        }
        ParserTreeNode node = Parser.genParseTree(expression);
        return node.operate();
    }

    private static ParserTreeNode genParseTree(String expression) throws SyntaxException {
        ParserTreeNode node;
        ArrayList<ParserTreeNode> nodes = new ArrayList<ParserTreeNode>();
        ArrayList<ArrayList<ParserTreeNode>> args = new ArrayList<ArrayList<ParserTreeNode>>();
        int comma = 0;
        int colon = 0;
        int[] nextOp = new int[OPERATORS.length()];
        int i = 0;
        while (i < expression.length()) {
            char c = expression.charAt(i);
            ParserTreeNode curr = null;
            if (!Character.isWhitespace(c)) {
                if (expression.length() - i > 3 && expression.substring(i).startsWith("(+)")) {
                    curr = new XOrOperatorNode(null, null);
                    i += 2;
                } else if (c == '(') {
                    int total = 1;
                    int index = i;
                    while (++index != expression.length()) {
                        if (expression.charAt(index) == '(' || expression.charAt(index) == '[') {
                            ++total;
                        }
                        if (expression.charAt(index) == ')' || expression.charAt(index) == ']') {
                            --total;
                        }
                        if (total != 0) continue;
                    }
                    curr = Parser.genParseTree(expression.substring(i + 1, index));
                    curr.setParenthesized(true);
                    i = index;
                } else if (c == '[') {
                    int total = 1;
                    int index = i;
                    while (++index != expression.length()) {
                        if (expression.charAt(index) == '(' || expression.charAt(index) == '[') {
                            ++total;
                        }
                        if (expression.charAt(index) == ')' || expression.charAt(index) == ']') {
                            --total;
                        }
                        if (total != 0) continue;
                    }
                    ParserTreeNode temp = Parser.genParseTree(expression.substring(i + 1, index));
                    curr = new SubscriptSliceOperatorNode(null);
                    ((SubscriptSliceOperatorNode)curr).setArgs(temp);
                    i = index;
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("++")) {
                    curr = nodes.isEmpty() || nodes.get(nodes.size() - 1) instanceof OperatorNode ? new PrefixIncrementOperatorNode(null) : new PostfixIncrementOperatorNode(null);
                    ++i;
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("--")) {
                    curr = nodes.isEmpty() || nodes.get(nodes.size() - 1) instanceof OperatorNode ? new PrefixDecrementOperatorNode(null) : new PostfixDecrementOperatorNode(null);
                    ++i;
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("+=")) {
                    curr = new AssignAddOperatorNode(null, null);
                    ++i;
                } else if (c == '+') {
                    curr = new AddOperatorNode(null, null);
                } else if (c == '&') {
                    curr = new AndOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("/=")) {
                    curr = new AssignDivideOperatorNode(null, null);
                    ++i;
                } else if (c == '/') {
                    curr = new DivideOperatorNode(null, null);
                } else if (expression.length() - i > 2 && expression.substring(i).startsWith("==")) {
                    curr = new EqualOperatorNode(null, null);
                    ++i;
                } else if (c == '=') {
                    curr = new AssignOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("^=")) {
                    curr = new AssignExpOperatorNode(null, null);
                    ++i;
                } else if (c == '^') {
                    curr = new ExpOperatorNode(null, null);
                } else if (expression.length() - i > 2 && expression.substring(i).startsWith(">=")) {
                    curr = new GreaterEqualOperatorNode(null, null);
                    ++i;
                } else if (c == '>') {
                    curr = new GreaterOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("<=")) {
                    curr = new LessEqualOperatorNode(null, null);
                    ++i;
                } else if (c == '<') {
                    curr = new LessOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("%=")) {
                    curr = new AssignModOperatorNode(null, null);
                    ++i;
                } else if (c == '%') {
                    curr = new ModOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("*=")) {
                    curr = new AssignMultiplyOperatorNode(null, null);
                    ++i;
                } else if (c == '*') {
                    curr = new MultiplyOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("!=")) {
                    curr = new NotEqualOperatorNode(null, null);
                    ++i;
                } else if (c == '!') {
                    curr = new NotOperatorNode(null);
                } else if (c == '|') {
                    curr = new OrOperatorNode(null, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("#=")) {
                    curr = new AssignRoundOperatorNode(null, null);
                    ++i;
                } else if (c == '#') {
                    curr = new RoundOperatorNode(null, null);
                } else if (c == '@') {
                    curr = new FunctionReferenceOperatorNode(interpreter, null);
                } else if (expression.length() - i >= 2 && expression.substring(i).startsWith("-=")) {
                    curr = new AssignSubtractOperatorNode(null, null);
                    ++i;
                } else if (c == '-') {
                    curr = nodes.isEmpty() || nodes.get(nodes.size() - 1) instanceof OperatorNode ? new NegationOperatorNode(null) : new SubtractOperatorNode(null, null);
                } else if (c == ',' || c == ':') {
                    if (c == ',') {
                        ++comma;
                    }
                    if (c == ':') {
                        ++colon;
                    }
                    ArrayList<ParserTreeNode> nodesCopy = new ArrayList<ParserTreeNode>(nodes);
                    args.add(nodesCopy);
                    nodes.clear();
                } else if (c == '\"') {
                    int place = i;
                    while (place != -1) {
                        if ((place = expression.indexOf(34, place + 1)) != -1 && expression.charAt(place - 1) != '\\') break;
                    }
                    if (place == -1) {
                        throw new SyntaxException("Incomplete quotation.");
                    }
                    curr = new DataNode(Parser.getValue(expression.substring(i, place + 1)));
                    i = place;
                } else {
                    Variable v;
                    int index = 0;
                    while (index < OPERATORS.length()) {
                        nextOp[index] = expression.indexOf(OPERATORS.charAt(index), i);
                        ++index;
                    }
                    Arrays.sort(nextOp);
                    index = 0;
                    while (index < nextOp.length && nextOp[index] <= 0) {
                        ++index;
                    }
                    if (index == nextOp.length) {
                        String expr = expression.substring(i).trim();
                        v = Parser.getValue(expr);
                        curr = v != null ? new DataNode(v) : new FunctionOperatorNode(Parser.getFunction(expr), null, null);
                        i = expression.length();
                    } else {
                        String expr = expression.substring(i, nextOp[index]).trim();
                        v = Parser.getValue(expr);
                        curr = v != null ? new DataNode(v) : new FunctionOperatorNode(Parser.getFunction(expr), null, null);
                        i = nextOp[index] - 1;
                    }
                }
                if (curr != null) {
                    nodes.add(curr);
                }
            }
            ++i;
        }
        args.add(nodes);
        if (args.size() == 1) {
            Parser.shrinkNodeList(nodes);
            if (nodes.size() > 1) {
                throw new SyntaxException("Could not parse expression.");
            }
            node = nodes.get(0);
        } else {
            node = new ArgListNode();
            for (ArrayList arrayList : args) {
                if (arrayList.size() == 0) {
                    ((ArgListNode)node).add(null);
                    continue;
                }
                Parser.shrinkNodeList(arrayList);
                ((ArgListNode)node).add((ParserTreeNode)arrayList.get(0));
            }
            if (comma != 0 && colon != 0) {
                ((ArgListNode)node).setColonDelineated(false);
                ((ArgListNode)node).setCommaDelineated(false);
            } else if (comma == 0 && colon != 0) {
                ((ArgListNode)node).setColonDelineated(true);
                ((ArgListNode)node).setCommaDelineated(false);
            } else if (comma != 0 && colon == 0) {
                ((ArgListNode)node).setColonDelineated(false);
                ((ArgListNode)node).setCommaDelineated(true);
            }
        }
        return node;
    }

    private static Variable getValue(String phrase) throws SyntaxException {
        Variable rVar = interpreter.getVariable(phrase);
        if (rVar != null) {
            rVar.setLiteral(false);
            return rVar;
        }
        if (phrase.startsWith("\"")) {
            StringVariable v = new StringVariable(phrase.substring(1, phrase.length() - 1));
            return v;
        }
        try {
            NumberVariable v = new NumberVariable(Double.parseDouble(phrase));
            return v;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Function getFunction(String identifier) {
        Function rFunc = interpreter.getFunction(identifier);
        if (rFunc == null) {
            throw new UnknownFunctionException(identifier);
        }
        return rFunc;
    }

    private static boolean parensMatch(String statement) {
        Stack<String> parens = new Stack<String>();
        boolean quote = false;
        int index = 0;
        while (index < statement.length()) {
            if (statement.charAt(index) == '\"') {
                boolean bl = quote = !quote;
            }
            if (!quote) {
                if (statement.charAt(index) == '(') {
                    parens.push("(");
                } else if (statement.charAt(index) == ')') {
                    if (parens.isEmpty() || !((String)parens.pop()).equals("(")) {
                        return false;
                    }
                } else if (statement.charAt(index) == '[') {
                    parens.push("[");
                } else if (statement.charAt(index) == ']' && (parens.isEmpty() || !((String)parens.pop()).equals("["))) {
                    return false;
                }
            }
            ++index;
        }
        return parens.isEmpty();
    }

    private static void shrinkNodeList(ArrayList<ParserTreeNode> nodes) {
        while (nodes.size() > 1) {
            int maxIndex = -1;
            int index = 0;
            while (index < nodes.size()) {
                ParserTreeNode curr = nodes.get(index);
                if (maxIndex < 0 && curr.left() == null && curr.right() == null && curr.getPrecedence() >= 0) {
                    maxIndex = index;
                } else if (maxIndex >= 0 && curr.getPrecedence() > nodes.get(maxIndex).getPrecedence() && curr.left() == null && curr.right() == null) {
                    maxIndex = index;
                }
                ++index;
            }
            if (maxIndex == -1) break;
            OperatorNode max = (OperatorNode)nodes.get(maxIndex);
            if (max.left() != null || max.right() != null) continue;
            if (max.isUnary()) {
                if (max.isLeftOperandUnary()) {
                    max.left(nodes.get(maxIndex - 1));
                    nodes.remove(maxIndex - 1);
                    continue;
                }
                max.right(nodes.get(maxIndex + 1));
                nodes.remove(maxIndex + 1);
                continue;
            }
            max.left(nodes.get(maxIndex - 1));
            max.right(nodes.get(maxIndex + 1));
            nodes.remove(maxIndex - 1);
            nodes.remove(maxIndex);
        }
    }
}

