/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class AssignDivideOperatorNode
extends OperatorNode {
    public AssignDivideOperatorNode(ParserTreeNode left, ParserTreeNode right) {
        super(left, right);
    }

    public Variable operate() {
        Variable l = this.left().operate();
        if (l.isLiteral()) {
            throw new SyntaxException("The left side of an assignment cannot be a literal.");
        }
        l.assign(l.divide(this.right().operate()));
        return l;
    }

    public String operator() {
        return "/=";
    }

    public int getPrecedence() {
        return 0;
    }
}

