/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.parser.ArgListNode;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class FunctionOperatorNode
extends OperatorNode {
    private Function function;
    private Variable[] b4;
    private Variable[] af;

    public FunctionOperatorNode(Function function, ParserTreeNode left, ParserTreeNode right) {
        super(left, right);
        this.function = function;
    }

    public Variable operate() {
        if (this.left() == null) {
            this.b4 = new Variable[0];
        } else {
            if (!this.left().isParenthesized()) {
                throw new SyntaxException("Function arguments must be parenthesized.");
            }
            if (!(this.left() instanceof ArgListNode)) {
                this.b4 = new Variable[1];
                this.b4[0] = this.left().operate().copy();
            } else {
                if (!((ArgListNode)this.left()).isCommaDelineated()) {
                    throw new SyntaxException("Function arguments must be comma delineated.");
                }
                this.b4 = ((ArgListNode)this.left()).getVariables();
            }
        }
        if (this.right() == null) {
            this.af = new Variable[0];
        } else {
            if (!this.right().isParenthesized()) {
                throw new SyntaxException("Function arguments must be parenthesized.");
            }
            if (!(this.right() instanceof ArgListNode)) {
                this.af = new Variable[1];
                this.af[0] = this.right().operate().copy();
            } else {
                if (!((ArgListNode)this.right()).isCommaDelineated()) {
                    throw new SyntaxException("Function arguments must be comma delineated.");
                }
                this.af = ((ArgListNode)this.right()).getVariables();
            }
        }
        this.function.run(this.b4, this.af);
        return this.function.getReturnValue();
    }

    public String operator() {
        return this.function.getName();
    }

    public Function getFunction() {
        return this.function;
    }

    public int getPrecedence() {
        if (this.function.getBeforeTypes().length == 0 && this.function.getAfterTypes().length == 0) {
            return 0;
        }
        return 11;
    }

    public boolean isUnary() {
        return this.function.getBeforeTypes().length == 0 || this.function.getAfterTypes().length == 0;
    }

    public boolean isLeftOperandUnary() {
        return this.isUnary() && this.function.getAfterTypes().length == 0;
    }

    public String toString() {
        if (this.left() == null && this.right() == null) {
            return this.function.getName();
        }
        if (this.left() == null) {
            return String.valueOf(this.function.getName()) + "(" + this.right().toString() + ")";
        }
        if (this.right() == null) {
            return "(" + this.left().toString() + ")" + this.function.getName();
        }
        return "(" + this.left().toString() + ")" + this.function.getName() + "(" + this.right().toString() + ")";
    }
}

