/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.FunctionVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class FunctionReferenceOperatorNode
extends OperatorNode {
    private Interpreter i;

    public FunctionReferenceOperatorNode(Interpreter i, ParserTreeNode right) {
        super(null, right);
        this.i = i;
    }

    public Variable operate() {
        Variable r = this.right().operate();
        if (!(r instanceof StringVariable)) {
            throw new SyntaxException("Argument to the @ operator must be a string of a function name.");
        }
        FunctionVariable f = new FunctionVariable(this.i.getFunction(((StringVariable)r).value()));
        return f;
    }

    public String operator() {
        return "@";
    }

    public int getPrecedence() {
        return 9;
    }

    public boolean isUnary() {
        return true;
    }

    public String toString() {
        return "@" + this.right().toString();
    }
}

