/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class NegationOperatorNode
extends OperatorNode {
    public NegationOperatorNode(ParserTreeNode right) {
        super(null, right);
    }

    public Variable operate() {
        Variable v = this.right().operate();
        if (!(v instanceof NumberVariable)) {
            throw new SyntaxException("Negation can only be performed on number variables.");
        }
        return new NumberVariable(-((NumberVariable)v).value());
    }

    public String operator() {
        return "-";
    }

    public int getPrecedence() {
        return 9;
    }

    public boolean isUnary() {
        return true;
    }

    public String toString() {
        return "-" + this.right().toString();
    }
}

