/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class PostfixIncrementOperatorNode
extends OperatorNode {
    public PostfixIncrementOperatorNode(ParserTreeNode left) {
        super(left, null);
    }

    public Variable operate() {
        Variable r = this.left().operate();
        if (r.isLiteral()) {
            throw new SyntaxException("Can not increment a literal value.");
        }
        if (!(r instanceof NumberVariable)) {
            throw new SyntaxException("Can only increment number variables.");
        }
        NumberVariable rVar = new NumberVariable(((NumberVariable)r).value());
        r.assign(r.add(new NumberVariable(1.0)));
        return rVar;
    }

    public String operator() {
        return "++";
    }

    public int getPrecedence() {
        return 10;
    }

    public boolean isUnary() {
        return true;
    }

    public boolean isLeftOperandUnary() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.left().toString()) + "++";
    }
}

