/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class PrefixIncrementOperatorNode
extends OperatorNode {
    public PrefixIncrementOperatorNode(ParserTreeNode right) {
        super(null, right);
    }

    public Variable operate() {
        Variable r = this.right().operate();
        if (r.isLiteral()) {
            throw new SyntaxException("Can not increment a literal value.");
        }
        if (!(r instanceof NumberVariable)) {
            throw new SyntaxException("Can only increment number variables.");
        }
        r.assign(r.add(new NumberVariable(1.0)));
        return r;
    }

    public String operator() {
        return "++";
    }

    public int getPrecedence() {
        return 9;
    }

    public boolean isUnary() {
        return true;
    }

    public String toString() {
        return "++" + this.right().toString();
    }
}

