/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.parser.operators;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.parser.ArgListNode;
import net.scheinerman.phoenix.interpreter.parser.ParserTreeNode;
import net.scheinerman.phoenix.interpreter.parser.operators.OperatorNode;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class SubscriptSliceOperatorNode
extends OperatorNode {
    private ParserTreeNode args;

    public SubscriptSliceOperatorNode(ParserTreeNode left) {
        super(left, null);
    }

    public void setArgs(ParserTreeNode args) {
        this.args = args;
    }

    public Variable operate() {
        if (this.args instanceof ArgListNode) {
            if (!((ArgListNode)this.args).isColonDelineated()) {
                throw new SyntaxException("Subscripts must be colon delineated");
            }
            ArgListNode temp = (ArgListNode)this.args;
            Variable[] vars = temp.getVariables();
            if (vars.length != 2) {
                throw new SyntaxException("Only two variables can be passed to the subscript/slice operator.");
            }
            return this.left().operate().subscript(vars[0], vars[1]);
        }
        return this.left().operate().subscript(this.args.operate());
    }

    public String operator() {
        return "[]";
    }

    public int getPrecedence() {
        return 11;
    }

    public boolean isUnary() {
        return true;
    }

    public boolean isLeftOperandUnary() {
        return true;
    }

    public String toString() {
        return String.valueOf(this.left().toString()) + "++";
    }
}

