/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.variables;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.exceptions.UnsupportedOperatorException;
import net.scheinerman.phoenix.interpreter.variables.AbstractVariable;
import net.scheinerman.phoenix.interpreter.variables.Constants;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class NumberVariable
extends AbstractVariable {
    private final NumberVariable TRUE = Constants.TRUE;
    private final NumberVariable FALSE = Constants.FALSE;
    private double value = 0.0;

    public NumberVariable() {
    }

    public NumberVariable(double value) {
        this(value, false);
    }

    public NumberVariable(Variable value) {
        this(value, false);
    }

    public NumberVariable(double value, boolean constant) {
        this.assign(value);
        this.constant = constant;
    }

    public NumberVariable(Variable value, boolean constant) {
        this.assign(value);
        this.constant = constant;
    }

    public void assign(double value) {
        if (this.constant) {
            throw new SyntaxException("Cannot assign to a constant.");
        }
        this.value = value;
    }

    public void assign(Variable v) {
        this.check(v);
        if (this.constant) {
            throw new SyntaxException("Cannot assign to a constant.");
        }
        this.value = ((NumberVariable)v).value();
    }

    public double value() {
        return this.value;
    }

    public String getType() {
        return "num";
    }

    public Variable add(Variable v) {
        if (v instanceof NumberVariable) {
            return new NumberVariable(this.value + ((NumberVariable)v).value());
        }
        if (this.value == (double)((int)this.value)) {
            return new StringVariable(String.valueOf((int)this.value) + ((StringVariable)v).value());
        }
        return new StringVariable(String.valueOf(this.value) + ((StringVariable)v).value());
    }

    public Variable subtract(Variable v) {
        this.check(v);
        return new NumberVariable(this.value - ((NumberVariable)v).value());
    }

    public Variable multiply(Variable v) {
        if (v instanceof NumberVariable) {
            return new NumberVariable(this.value * ((NumberVariable)v).value());
        }
        return v.multiply(this);
    }

    public Variable divide(Variable v) {
        this.check(v);
        return new NumberVariable(this.value / ((NumberVariable)v).value());
    }

    public Variable mod(Variable v) {
        this.check(v);
        return new NumberVariable(this.value % ((NumberVariable)v).value());
    }

    public Variable exp(Variable v) {
        this.check(v);
        return new NumberVariable(Math.pow(this.value, ((NumberVariable)v).value()));
    }

    public Variable round(Variable v) {
        this.check(v);
        double value2 = ((NumberVariable)v).value();
        double remainder = this.value % value2;
        if (remainder < value2 / 2.0) {
            return new NumberVariable(this.value - remainder);
        }
        return new NumberVariable(this.value - remainder + value2);
    }

    public Variable isEqualTo(Variable v) {
        this.check(v);
        return (this.value == ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable notEqualTo(Variable v) {
        this.check(v);
        return (this.value != ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable greaterThan(Variable v) {
        this.check(v);
        return (this.value > ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable greaterEqual(Variable v) {
        this.check(v);
        return (this.value >= ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable lessThan(Variable v) {
        this.check(v);
        return (this.value < ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable lessEqual(Variable v) {
        this.check(v);
        return (this.value <= ((NumberVariable)v).value() ? this.TRUE : this.FALSE).copy();
    }

    public Variable and(Variable v) {
        this.check(v);
        return (this.value != 0.0 && ((NumberVariable)v).value() != 0.0 ? this.TRUE : this.FALSE).copy();
    }

    public Variable or(Variable v) {
        this.check(v);
        return (this.value != 0.0 || ((NumberVariable)v).value() != 0.0 ? this.TRUE : this.FALSE).copy();
    }

    public Variable xor(Variable v) {
        this.check(v);
        double value2 = ((NumberVariable)v).value();
        return (this.value == 0.0 && value2 != 0.0 || this.value != 0.0 && value2 == 0.0 ? this.TRUE : this.FALSE).copy();
    }

    public Variable not() {
        return this.value == 0.0 ? this.TRUE : this.FALSE;
    }

    public Variable subscript(Variable sub) {
        throw new UnsupportedOperatorException(this, "[]");
    }

    public Variable subscript(Variable sub1, Variable sub2) {
        throw new UnsupportedOperatorException(this, "[]");
    }

    public void check(Variable v) {
        if (!(v instanceof NumberVariable)) {
            throw new SyntaxException();
        }
    }

    public String toString() {
        if (this.value == (double)((int)this.value)) {
            return String.valueOf((int)this.value);
        }
        return String.valueOf(this.value);
    }

    public Variable copy() {
        return new NumberVariable(this.value);
    }
}

