/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.interpreter.variables;

import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.exceptions.UnsupportedOperatorException;
import net.scheinerman.phoenix.interpreter.variables.AbstractVariable;
import net.scheinerman.phoenix.interpreter.variables.Constants;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.Variable;

public class StringVariable
extends AbstractVariable {
    private final NumberVariable TRUE = Constants.TRUE;
    private final NumberVariable FALSE = Constants.FALSE;
    private String value = "";

    public StringVariable() {
    }

    public StringVariable(String value) {
        this(value, false);
    }

    public StringVariable(Variable value) {
        this(value, false);
    }

    public StringVariable(String value, boolean constant) {
        this.assign(value);
        this.constant = constant;
    }

    public StringVariable(Variable value, boolean constant) {
        this.assign(value);
        this.constant = constant;
    }

    public void assign(String value) {
        this.value = value;
    }

    public void assign(Variable v) {
        this.check(v);
        if (this.constant) {
            throw new SyntaxException("Cannot assign to a constant.");
        }
        this.value = ((StringVariable)v).value();
    }

    public String value() {
        return this.value;
    }

    public String getType() {
        return "str";
    }

    public Variable add(Variable v) {
        if (v instanceof StringVariable) {
            return new StringVariable(String.valueOf(this.value) + ((StringVariable)v).value());
        }
        double val = ((NumberVariable)v).value();
        if (val == (double)((int)val)) {
            return new StringVariable(String.valueOf(this.value) + (int)val);
        }
        return new StringVariable(String.valueOf(this.value) + val);
    }

    public Variable subtract(Variable v) {
        throw new UnsupportedOperatorException(this, "-");
    }

    public Variable multiply(Variable v) {
        if (!(v instanceof NumberVariable)) {
            throw new SyntaxException();
        }
        if (((NumberVariable)v).value() < 0.0) {
            throw new SyntaxException("String multiplier must be > 0.");
        }
        if (((NumberVariable)v).value() != (double)((int)((NumberVariable)v).value())) {
            throw new SyntaxException("String multiplier must be an integer.");
        }
        String retVal = "";
        int i = 0;
        while ((double)i < ((NumberVariable)v).value()) {
            retVal = String.valueOf(retVal) + this.value;
            ++i;
        }
        return new StringVariable(retVal);
    }

    public Variable divide(Variable v) {
        throw new UnsupportedOperatorException(this, "/");
    }

    public Variable mod(Variable v) {
        throw new UnsupportedOperatorException(this, "%");
    }

    public Variable exp(Variable v) {
        throw new UnsupportedOperatorException(this, "^");
    }

    public Variable round(Variable v) {
        throw new UnsupportedOperatorException(this, "#");
    }

    public Variable isEqualTo(Variable v) {
        return this.value.equals(((StringVariable)v).value()) ? this.TRUE : this.FALSE;
    }

    public Variable notEqualTo(Variable v) {
        return !this.value.equals(((StringVariable)v).value()) ? this.TRUE : this.FALSE;
    }

    public Variable greaterThan(Variable v) {
        return this.value.compareTo(((StringVariable)v).value()) > 0 ? this.TRUE : this.FALSE;
    }

    public Variable greaterEqual(Variable v) {
        return this.value.compareTo(((StringVariable)v).value()) >= 0 ? this.TRUE : this.FALSE;
    }

    public Variable lessThan(Variable v) {
        return this.value.compareTo(((StringVariable)v).value()) < 0 ? this.TRUE : this.FALSE;
    }

    public Variable lessEqual(Variable v) {
        return this.value.compareTo(((StringVariable)v).value()) <= 0 ? this.TRUE : this.FALSE;
    }

    public Variable and(Variable v) {
        throw new UnsupportedOperatorException(this, "&");
    }

    public Variable or(Variable v) {
        throw new UnsupportedOperatorException(this, "|");
    }

    public Variable xor(Variable v) {
        throw new UnsupportedOperatorException(this, "(+)");
    }

    public Variable not() {
        throw new UnsupportedOperatorException(this, "!");
    }

    public Variable subscript(Variable sub) {
        if (sub instanceof NumberVariable) {
            NumberVariable subTemp = (NumberVariable)sub;
            if (subTemp.value() != (double)((int)subTemp.value())) {
                throw new SyntaxException("Subscript value must be an integer.");
            }
            return new StringVariable("" + this.value.charAt(this.convertValue((int)subTemp.value())));
        }
        StringVariable temp = (StringVariable)sub;
        return this.value.contains(temp.value()) ? this.TRUE : this.FALSE;
    }

    public Variable subscript(Variable sub1, Variable sub2) {
        if (sub1 == null && sub2 == null) {
            return new StringVariable(this.value);
        }
        if (sub1 == null) {
            if (sub2 instanceof NumberVariable) {
                NumberVariable temp = (NumberVariable)sub2;
                if (temp.value() != (double)((int)temp.value())) {
                    throw new SyntaxException("Subscript value must be an integer.");
                }
                int val = this.convertValue((int)temp.value());
                return new StringVariable(this.value.substring(0, val));
            }
            StringVariable temp = (StringVariable)sub2;
            return new NumberVariable(this.value.lastIndexOf(temp.value()));
        }
        if (sub2 == null) {
            if (sub1 instanceof NumberVariable) {
                NumberVariable temp = (NumberVariable)sub1;
                if (temp.value() != (double)((int)temp.value())) {
                    throw new SyntaxException("Subscript value must be an integer.");
                }
                int val = this.convertValue((int)temp.value());
                return new StringVariable(this.value.substring(val));
            }
            StringVariable temp = (StringVariable)sub1;
            return new NumberVariable(this.value.indexOf(temp.value()));
        }
        if (sub1 instanceof NumberVariable) {
            NumberVariable temp1 = (NumberVariable)sub1;
            if (temp1.value() != (double)((int)temp1.value())) {
                throw new SyntaxException("Subscript value must be an integer.");
            }
            int val1 = this.convertValue((int)temp1.value());
            if (sub2 instanceof NumberVariable) {
                NumberVariable temp2 = (NumberVariable)sub2;
                if (temp2.value() != (double)((int)temp2.value())) {
                    throw new SyntaxException("Subscript value must be an integer.");
                }
                int val2 = this.convertValue((int)temp2.value());
                return new StringVariable(this.value.substring(val1, val2));
            }
            StringVariable temp2 = (StringVariable)sub2;
            return new NumberVariable(this.value.lastIndexOf(temp2.value(), val1));
        }
        if (sub2 instanceof StringVariable) {
            throw new SyntaxException("Subscript cannot take form str[str:str]");
        }
        StringVariable temp1 = (StringVariable)sub1;
        NumberVariable temp2 = (NumberVariable)sub2;
        if (temp2.value() != (double)((int)temp2.value())) {
            throw new SyntaxException("Subscript value must be an integer.");
        }
        int val2 = this.convertValue((int)temp2.value());
        return new NumberVariable(this.value.indexOf(temp1.value(), val2));
    }

    private int convertValue(int value) {
        if (value < -this.value.length() || value > this.value.length()) {
            throw new SyntaxException("Subscript value out of range.");
        }
        int retVal = value;
        if (value < 0) {
            retVal = this.value.length() + value;
        }
        return retVal;
    }

    public void check(Variable v) {
        if (!(v instanceof StringVariable)) {
            throw new SyntaxException();
        }
    }

    public String toString() {
        return this.value;
    }

    public Variable copy() {
        return new StringVariable(this.value);
    }
}

