/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.library;

import net.scheinerman.phoenix.interpreter.exceptions.IllegalArgumentException;
import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.library.AbstractModule;

public class MathFunctions
extends AbstractModule {
    public MathFunctions() {
        super("math");
        this.functions.add(new Abs());
        this.functions.add(new ArcCos());
        this.functions.add(new ArcSin());
        this.functions.add(new ArcTan());
        this.functions.add(new Ceil());
        this.functions.add(new Cos());
        this.functions.add(new CosH());
        this.functions.add(new E());
        this.functions.add(new Exp());
        this.functions.add(new Factorial());
        this.functions.add(new Floor());
        this.functions.add(new Hypot());
        this.functions.add(new Log());
        this.functions.add(new Log10());
        this.functions.add(new LogB());
        this.functions.add(new Max());
        this.functions.add(new Min());
        this.functions.add(new PI());
        this.functions.add(new Random());
        this.functions.add(new RandomInt());
        this.functions.add(new Root());
        this.functions.add(new Sin());
        this.functions.add(new SinH());
        this.functions.add(new Sqrt());
        this.functions.add(new Tan());
        this.functions.add(new TanH());
    }

    private class Abs
    extends BuiltInFunction {
        public Abs() {
            super("abs", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.abs(d));
        }
    }

    private class ArcCos
    extends BuiltInFunction {
        public ArcCos() {
            super("arccos", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.acos(d));
        }
    }

    private class ArcSin
    extends BuiltInFunction {
        public ArcSin() {
            super("arcsin", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.asin(d));
        }
    }

    private class ArcTan
    extends BuiltInFunction {
        public ArcTan() {
            super("arctan", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.atan(d));
        }
    }

    private class Ceil
    extends BuiltInFunction {
        public Ceil() {
            super("ceil", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"n"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.ceil(d));
        }
    }

    private class Cos
    extends BuiltInFunction {
        public Cos() {
            super("cos", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.cos(d));
        }
    }

    private class CosH
    extends BuiltInFunction {
        public CosH() {
            super("cosh", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.cosh(d));
        }
    }

    private class E
    extends BuiltInFunction {
        public E() {
            super("E", "num", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new NumberVariable(Math.E);
        }
    }

    private class Exp
    extends BuiltInFunction {
        public Exp() {
            super("exp", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.exp(d));
        }
    }

    private class Factorial
    extends BuiltInFunction {
        public Factorial() {
            super("factorial", "num", new String[]{"num"}, new String[0], new String[]{"n"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            try {
                double i = Double.parseDouble(left[0]);
                if (i < 0.0) {
                    throw new IllegalArgumentException("Argument to factorial must be a non negative integer.");
                }
                double prod = 1.0;
                int loop = 2;
                while ((double)loop <= i) {
                    prod *= (double)loop;
                    ++loop;
                }
                this.retValue = new NumberVariable(prod);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Argument to factorial must be a non negative integer.");
            }
        }
    }

    private class Floor
    extends BuiltInFunction {
        public Floor() {
            super("floor", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"n"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.floor(d));
        }
    }

    private class Hypot
    extends BuiltInFunction {
        public Hypot() {
            super("hypot", "num", new String[0], new String[]{"num", "num"}, new String[0], new String[]{"x", "y"});
        }

        public void run(String[] left, String[] right) {
            Double d1 = Double.parseDouble(right[0]);
            Double d2 = Double.parseDouble(right[1]);
            this.retValue = new NumberVariable(Math.hypot(d1, d2));
        }
    }

    private class Log
    extends BuiltInFunction {
        public Log() {
            super("log", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.log(d));
        }
    }

    private class Log10
    extends BuiltInFunction {
        public Log10() {
            super("log10", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.log10(d));
        }
    }

    private class LogB
    extends BuiltInFunction {
        public LogB() {
            super("logb", "num", new String[0], new String[]{"num", "num"}, new String[0], new String[]{"base", "x"});
        }

        public void run(String[] left, String[] right) {
            Double b = Double.parseDouble(right[0]);
            Double n = Double.parseDouble(right[1]);
            this.retValue = new NumberVariable(Math.log(n) / Math.log(b));
        }
    }

    private class Max
    extends BuiltInFunction {
        public Max() {
            super("max", "num", new String[]{"num"}, new String[]{"num"}, new String[]{"a"}, new String[]{"b"});
        }

        public void run(String[] left, String[] right) {
            Double a = Double.parseDouble(left[0]);
            Double b = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.max(a, b));
        }
    }

    private class Min
    extends BuiltInFunction {
        public Min() {
            super("min", "num", new String[]{"num"}, new String[]{"num"}, new String[]{"a"}, new String[]{"b"});
        }

        public void run(String[] left, String[] right) {
            Double a = Double.parseDouble(right[0]);
            Double b = Double.parseDouble(left[0]);
            this.retValue = new NumberVariable(Math.min(a, b));
        }
    }

    private class PI
    extends BuiltInFunction {
        public PI() {
            super("PI", "num", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new NumberVariable(Math.PI);
        }
    }

    private class Random
    extends BuiltInFunction {
        public Random() {
            super("rand", "num", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new NumberVariable(Math.random());
        }
    }

    private class RandomInt
    extends BuiltInFunction {
        public RandomInt() {
            super("randInt", "num", new String[]{"num"}, new String[]{"num"}, new String[]{"min"}, new String[]{"max"});
        }

        public void run(String[] left, String[] right) {
            Double a = Double.parseDouble(left[0]);
            Double b = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable((int)(Math.random() * (b - a + 1.0) + a));
        }
    }

    private class Root
    extends BuiltInFunction {
        public Root() {
            super("root", "num", new String[]{"num"}, new String[]{"num"}, new String[]{"n"}, new String[]{"x"});
            this.description = "Calculates the nth root of the number x.";
            this.argDescriptions.put("n", "The index (the type of root).");
            this.argDescriptions.put("x", "The radicand (the value under the radical).");
            this.returnDescription = "The nth root of x.";
        }

        public void run(String[] left, String[] right) {
            Double a = Double.parseDouble(left[0]);
            Double b = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.pow(b, 1.0 / a));
        }
    }

    private class Sin
    extends BuiltInFunction {
        public Sin() {
            super("sin", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.sin(d));
        }
    }

    private class SinH
    extends BuiltInFunction {
        public SinH() {
            super("sinh", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.sinh(d));
        }
    }

    private class Sqrt
    extends BuiltInFunction {
        public Sqrt() {
            super("sqrt", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.sqrt(d));
        }
    }

    private class Tan
    extends BuiltInFunction {
        public Tan() {
            super("tan", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.tan(d));
        }
    }

    private class TanH
    extends BuiltInFunction {
        public TanH() {
            super("tanh", "num", new String[0], new String[]{"num"}, new String[0], new String[]{"x"});
        }

        public void run(String[] left, String[] right) {
            Double d = Double.parseDouble(right[0]);
            this.retValue = new NumberVariable(Math.tanh(d));
        }
    }
}

