/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.variables.Constants;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.library.AbstractModule;
import net.scheinerman.phoenix.library.StackFunctions;

public class SetFunctions
extends AbstractModule {
    public static HashMap<String, SetContainer> SETS = new HashMap();

    public void reset() {
        SETS.clear();
    }

    public SetFunctions() {
        super("set");
        this.functions.add(new Create());
        this.functions.add(new CreateFromStack());
        this.functions.add(new Exists());
        this.functions.add(new Size());
        this.functions.add(new Add());
        this.functions.add(new Contains());
        this.functions.add(new Clear());
        this.functions.add(new Delete());
    }

    public void checkIfSetExists(String name) {
        if (SETS.containsKey(name)) {
            throw new PhoenixRuntimeException("Overwrite error", "The set '" + name + "' already exists.");
        }
    }

    public void checkIfSetDoesNotExist(String name) {
        if (!SETS.containsKey(name)) {
            throw new PhoenixRuntimeException("No such element error", "The set '" + name + "' does not exist.");
        }
    }

    private class Add
    extends BuiltInFunction {
        public Add() {
            super("add", "void", new String[]{"str"}, new String[]{"str"}, new String[]{"name"}, new String[]{"value"});
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetDoesNotExist(left[0]);
            SetFunctions.SETS.get((Object)left[0]).set.add(right[0]);
        }
    }

    private class Clear
    extends BuiltInFunction {
        public Clear() {
            super("clear", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetDoesNotExist(left[0]);
            SetFunctions.SETS.get((Object)left[0]).set.clear();
        }
    }

    private class Contains
    extends BuiltInFunction {
        public Contains() {
            super("contains", "num", new String[]{"str"}, new String[]{"str"}, new String[]{"name"}, new String[]{"item"});
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetDoesNotExist(left[0]);
            this.retValue = SetFunctions.SETS.get((Object)left[0]).set.contains(right[0]) ? Constants.TRUE : Constants.FALSE;
        }
    }

    private class Create
    extends BuiltInFunction {
        public Create() {
            super("create", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetExists(left[0]);
            SETS.put(left[0], new SetContainer());
        }
    }

    private class CreateFromStack
    extends BuiltInFunction {
        public CreateFromStack() {
            super("createFromStack", "void", new String[]{"str"}, new String[]{"str"}, new String[]{"name"}, new String[]{"stackName"});
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetExists(left[0]);
            StackFunctions.checkIfStackDoesNotExist(right[0]);
            SetContainer set = new SetContainer();
            set.set = new TreeSet<String>(StackFunctions.STACKS.get((Object)right[0]).stack);
            SETS.put(left[0], new SetContainer());
        }
    }

    private class Delete
    extends BuiltInFunction {
        public Delete() {
            super("delete", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetDoesNotExist(left[0]);
            SETS.remove(left[0]);
        }
    }

    private class Exists
    extends BuiltInFunction {
        public Exists() {
            super("exists", "num", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = SETS.containsKey(left[0]) ? Constants.TRUE : Constants.FALSE;
        }
    }

    class SetContainer {
        public TreeSet<String> set = new TreeSet();
        public Iterator<String> setItr;
    }

    private class Size
    extends BuiltInFunction {
        public Size() {
            super("size", "num", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            SetFunctions.this.checkIfSetDoesNotExist(left[0]);
            this.retValue = new NumberVariable(SetFunctions.SETS.get((Object)left[0]).set.size());
        }
    }
}

