/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.variables.Constants;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.library.AbstractModule;

public class StackFunctions
extends AbstractModule {
    public static HashMap<String, StackContainer> STACKS = new HashMap();

    public void reset() {
        STACKS.clear();
    }

    public StackFunctions() {
        super("stack");
        this.functions.add(new Create());
        this.functions.add(new Exists());
        this.functions.add(new Size());
        this.functions.add(new Push());
        this.functions.add(new Peek());
        this.functions.add(new Pop());
        this.functions.add(new Clear());
        this.functions.add(new Delete());
    }

    public static void checkIfStackExists(String name) {
        if (STACKS.containsKey(name)) {
            throw new PhoenixRuntimeException("Overwrite error", "The stack '" + name + "' already exists.");
        }
    }

    public static void checkIfStackDoesNotExist(String name) {
        if (!STACKS.containsKey(name)) {
            throw new PhoenixRuntimeException("No such element error", "The stack '" + name + "' does not exist.");
        }
    }

    private class Clear
    extends BuiltInFunction {
        public Clear() {
            super("clear", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            StackFunctions.STACKS.get((Object)left[0]).stack.clear();
        }
    }

    private class Create
    extends BuiltInFunction {
        public Create() {
            super("create", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackExists(left[0]);
            STACKS.put(left[0], new StackContainer());
        }
    }

    private class Delete
    extends BuiltInFunction {
        public Delete() {
            super("delete", "void", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            STACKS.remove(left[0]);
        }
    }

    private class Exists
    extends BuiltInFunction {
        public Exists() {
            super("exists", "num", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = STACKS.containsKey(left[0]) ? Constants.TRUE : Constants.FALSE;
        }
    }

    private class Peek
    extends BuiltInFunction {
        public Peek() {
            super("peek", "str", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            this.retValue = new StringVariable(StackFunctions.STACKS.get((Object)left[0]).stack.peek());
        }
    }

    private class Pop
    extends BuiltInFunction {
        public Pop() {
            super("pop", "str", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            this.retValue = new StringVariable(StackFunctions.STACKS.get((Object)left[0]).stack.pop());
        }
    }

    private class Push
    extends BuiltInFunction {
        public Push() {
            super("push", "void", new String[]{"str"}, new String[]{"str"}, new String[]{"name"}, new String[]{"item"});
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            StackFunctions.STACKS.get((Object)left[0]).stack.push(right[0]);
        }
    }

    private class Size
    extends BuiltInFunction {
        public Size() {
            super("size", "num", new String[]{"str"}, new String[0], new String[]{"name"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            StackFunctions.checkIfStackDoesNotExist(left[0]);
            this.retValue = new NumberVariable(StackFunctions.STACKS.get((Object)left[0]).stack.size());
        }
    }

    class StackContainer {
        public Stack<String> stack = new Stack();
        public Iterator<String> stackItr;
    }
}

