/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.library;

import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.library.AbstractModule;

public class StringFunctions
extends AbstractModule {
    public StringFunctions() {
        super("str");
        this.functions.add(new InLowerCase());
        this.functions.add(new InUpperCase());
        this.functions.add(new Length());
    }

    private class InLowerCase
    extends BuiltInFunction {
        public InLowerCase() {
            super("inLowerCase", "str", new String[]{"str"}, new String[0], new String[]{"string"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new StringVariable(left[0].toLowerCase());
        }
    }

    private class InUpperCase
    extends BuiltInFunction {
        public InUpperCase() {
            super("inUpperCase", "str", new String[]{"str"}, new String[0], new String[]{"string"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new StringVariable(left[0].toUpperCase());
        }
    }

    private class Length
    extends BuiltInFunction {
        public Length() {
            super("length", "num", new String[0], new String[]{"str"}, new String[0], new String[]{"string"});
        }

        public void run(String[] left, String[] right) {
            this.retValue = new NumberVariable(right[0].length());
        }
    }
}

