/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.library;

import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.exceptions.PhoenixRuntimeException;
import net.scheinerman.phoenix.interpreter.exceptions.SyntaxException;
import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.variables.NumberVariable;
import net.scheinerman.phoenix.interpreter.variables.StringVariable;
import net.scheinerman.phoenix.library.AbstractModule;

public class SystemFunctions
extends AbstractModule {
    private static String[] args;
    private long tic_start = -1L;

    public static void setArgs(String[] args) {
        SystemFunctions.args = args;
    }

    public SystemFunctions() {
        super("sys");
        this.functions.add(new Arg());
        this.functions.add(new AsNumber());
        this.functions.add(new AsString());
        this.functions.add(new ErrorMessage());
        this.functions.add(new Exit());
        this.functions.add(new Print());
        this.functions.add(new PrintLn());
        this.functions.add(new Tic());
        this.functions.add(new Toc());
    }

    private class Arg
    extends BuiltInFunction {
        public Arg() {
            super("arg", "str", new String[0], new String[]{"num"}, new String[0], new String[]{"index"});
        }

        public void run(String[] left, String[] right) {
            double d = Double.parseDouble(left[0]);
            if (d != (double)((int)d)) {
                throw new SyntaxException("Passed value to 'arg' must be an integer.");
            }
            int i = (int)d;
            if (i < 0 || i >= args.length) {
                throw new SyntaxException("Index out of bounds.");
            }
            this.retValue = new StringVariable(args[i]);
        }
    }

    private class AsNumber
    extends BuiltInFunction {
        public AsNumber() {
            super("asNum", "num", new String[]{"str"}, new String[0], new String[]{"value"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = new NumberVariable(Double.parseDouble(left[0]));
        }
    }

    private class AsString
    extends BuiltInFunction {
        public AsString() {
            super("asStr", "str", new String[]{"num"}, new String[0], new String[]{"value"}, new String[0]);
        }

        public void run(String[] left, String[] right) {
            double d = Double.parseDouble(left[0]);
            this.retValue = d == (double)((int)d) ? new StringVariable(String.valueOf((int)d)) : new StringVariable(String.valueOf(d));
        }
    }

    private class ErrorMessage
    extends BuiltInFunction {
        public ErrorMessage() {
            super("errorMessage", "str", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            PhoenixRuntimeException exception = InterpreterData.ERROR;
            this.retValue = exception == null ? new StringVariable("No error.") : new StringVariable(exception.getBriefMessage());
        }
    }

    private class Exit
    extends BuiltInFunction {
        public Exit() {
            super("exit", "void", new String[0], new String[]{"num"}, new String[0], new String[]{"value"});
        }

        public void run(String[] left, String[] right) {
            double d = Double.parseDouble(right[0]);
            System.exit((int)d);
        }
    }

    private class Print
    extends BuiltInFunction {
        public Print() {
            super("print", "void", new String[0], new String[]{"str"}, new String[0], new String[]{"value"});
        }

        public void run(String[] left, String[] right) {
            try {
                double d = Double.parseDouble(right[0]);
                if (d == (double)((int)d)) {
                    InterpreterData.printOut((int)d);
                } else {
                    InterpreterData.printOut(d);
                }
            }
            catch (NumberFormatException e) {
                InterpreterData.printOut(right[0]);
            }
        }
    }

    private class PrintLn
    extends BuiltInFunction {
        public PrintLn() {
            super("println", "void", new String[0], new String[]{"str"}, new String[0], new String[]{"value"});
        }

        public void run(String[] left, String[] right) {
            try {
                double d = Double.parseDouble(right[0]);
                if (d == (double)((int)d)) {
                    InterpreterData.printlnOut((int)d);
                } else {
                    InterpreterData.printlnOut(d);
                }
            }
            catch (NumberFormatException e) {
                InterpreterData.printlnOut(right[0]);
            }
        }
    }

    private class Tic
    extends BuiltInFunction {
        public Tic() {
            super("tic", "void", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            SystemFunctions.this.tic_start = System.currentTimeMillis();
        }
    }

    private class Toc
    extends BuiltInFunction {
        public Toc() {
            super("toc", "num", new String[0], new String[0], new String[0], new String[0]);
        }

        public void run(String[] left, String[] right) {
            this.retValue = SystemFunctions.this.tic_start == -1L ? new NumberVariable(0.0) : new NumberVariable(System.currentTimeMillis() - SystemFunctions.this.tic_start);
        }
    }
}

