/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.runner;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.TreeMap;
import net.scheinerman.phoenix.interpreter.InteractiveInterpreter;
import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.functions.BuiltInFunction;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.Variable;
import net.scheinerman.phoenix.library.AbstractModule;
import net.scheinerman.phoenix.library.DefaultModules;
import net.scheinerman.phoenix.runner.PhoenixEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractivePhoenixEnvironment
extends PhoenixEnvironment {
    private LinkedList<HashMap<String, Variable>> vat = new LinkedList();
    private LinkedList<HashMap<String, Function>> fat = new LinkedList();
    private InteractiveInterpreter interpreter;
    private boolean exited = false;

    public boolean isExited() {
        return this.exited;
    }

    public InteractivePhoenixEnvironment(boolean includeDefaultModules) {
        this(includeDefaultModules, System.in, System.out, System.err);
    }

    public InteractivePhoenixEnvironment(boolean includeDefaultModules, InputStream inputStream, PrintStream outputStream, PrintStream errorStream) {
        super(includeDefaultModules, inputStream, outputStream, errorStream);
        InterpreterData.IN = inputStream;
        InterpreterData.OUT = outputStream;
        InterpreterData.ERR = errorStream;
        this.vat.add(new HashMap());
        this.fat.add(new HashMap());
        new InteractiveFunctions(this.fat).load(this.fat.getFirst());
        if (includeDefaultModules) {
            new DefaultModules().load(this.fat.getFirst());
        }
        this.interpreter = new InteractiveInterpreter(this.vat, this.fat);
    }

    public LinkedList<HashMap<String, Variable>> getVAT() {
        return this.vat;
    }

    public LinkedList<HashMap<String, Function>> getFAT() {
        return this.fat;
    }

    @Override
    public void addModule(AbstractModule module) {
        this.modules.add(module);
        module.load(this.fat.getFirst());
    }

    public void addModules(ArrayList<AbstractModule> modules) {
        this.modules.addAll(modules);
        for (AbstractModule mod : modules) {
            mod.load(this.fat.getFirst());
        }
    }

    @Override
    public void resetModules() {
        throw new UnsupportedOperationException("resetModules() not applicable for InteractivePhoenixInterpreter");
    }

    public final void run(File file) {
        throw new UnsupportedOperationException("run(File) not applicable for InteractivePhoenixInterpreter");
    }

    public void runCode(String code) {
        try {
            this.interpreter.runCode(code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InteractiveFunctions
    extends AbstractModule {
        public InteractiveFunctions(LinkedList<HashMap<String, Function>> fat) {
            super("");
            this.functions.add(new About());
            this.functions.add(new Copyright());
            this.functions.add(new License());
            this.functions.add(new Exit());
            this.functions.add(new Help());
            this.functions.add(new Search());
            this.run_fat = fat;
        }

        private class About
        extends BuiltInFunction {
            public About() {
                super("about", "void", new String[0], new String[0], new String[0], new String[0]);
                this.description = "Displays information about Phoenix. This function is only available within the interactive shell and can only be used there.";
            }

            public void run(String[] left, String[] right) {
                try {
                    Scanner sc = new Scanner(this.getClass().getResourceAsStream("About.txt"));
                    while (sc.hasNextLine()) {
                        System.out.println("    " + sc.nextLine());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class Copyright
        extends BuiltInFunction {
            public Copyright() {
                super("copyright", "void", new String[0], new String[0], new String[0], new String[0]);
                this.description = "Displays copyright information about Phoenix. This function is only available within the interactive shell and can only be used there.";
            }

            public void run(String[] left, String[] right) {
                try {
                    Scanner sc = new Scanner(this.getClass().getResourceAsStream("Copyright.txt"));
                    while (sc.hasNextLine()) {
                        System.out.println("    " + sc.nextLine());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class Exit
        extends BuiltInFunction {
            public Exit() {
                super("exit", "void", new String[0], new String[0], new String[0], new String[0]);
                this.description = "Exits the Phoenix interactive shell. This function is only available within the interactive shell and can only be used there. To exit any Phoenix program (including the shell), use the sys.exit ( num ) function.";
            }

            public void run(String[] left, String[] right) {
                InteractivePhoenixEnvironment.this.exited = true;
            }
        }

        private class Help
        extends BuiltInFunction {
            public Help() {
                super("help", "void", new String[0], new String[]{"str"}, new String[0], new String[]{"functionName"});
                this.description = "Provides the built in help for a given function name. If that function does not exist, no help will be provided. To find functions with similar names, use the search ( str ) function. This function is only available within the interactive shell and can only be used there.";
                this.argDescriptions.put("functionName", "The function to provide information on.");
            }

            public void run(String[] left, String[] right) {
                if (right[0].equals("")) {
                    InterpreterData.printlnOut("Type help(\"help\") for more information...");
                    return;
                }
                TreeMap<String, Function> functions = new TreeMap<String, Function>();
                for (HashMap fat : InteractiveFunctions.this.run_fat) {
                    for (String s : fat.keySet()) {
                        if (!s.toLowerCase().contains(right[0].toLowerCase())) continue;
                        functions.put(s, (Function)fat.get(s));
                    }
                }
                if (functions.size() == 0) {
                    InterpreterData.printlnOut("No matching functions could be found.");
                } else {
                    Function f = (Function)functions.get(functions.keySet().iterator().next());
                    f.printHelp();
                }
            }
        }

        private class License
        extends BuiltInFunction {
            public License() {
                super("license", "void", new String[0], new String[0], new String[0], new String[0]);
                this.description = "Displays license information about Phoenix. This function is only available within the interactive shell and can only be used there.";
            }

            public void run(String[] left, String[] right) {
                try {
                    Scanner sc = new Scanner(this.getClass().getResourceAsStream("License.txt"));
                    while (sc.hasNextLine()) {
                        System.out.println("    " + sc.nextLine());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private class Search
        extends BuiltInFunction {
            public Search() {
                super("search", "void", new String[0], new String[]{"str"}, new String[0], new String[]{"searchTerm"});
                this.description = "Searchs for all function that the search term in there name (case insensitive). This function can be used with the help ( str ) function to find functions and learn information about them. This functionis only available within the interactive shell and can only be used there.";
            }

            public void run(String[] left, String[] right) {
                TreeMap<String, Function> functions = new TreeMap<String, Function>();
                for (HashMap fat : InteractiveFunctions.this.run_fat) {
                    for (String s : fat.keySet()) {
                        if (!s.toLowerCase().contains(right[0].toLowerCase())) continue;
                        functions.put(s, (Function)fat.get(s));
                    }
                }
                if (functions.size() == 0) {
                    InterpreterData.printlnOut("No matching functions could be found.");
                } else {
                    InterpreterData.printlnOut("All functions matching that search query:");
                    for (String s : functions.keySet()) {
                        InterpreterData.printlnOut("    " + s);
                    }
                }
            }
        }
    }
}

