/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.runner;

import java.io.File;
import java.util.Scanner;
import java.util.TreeMap;
import net.scheinerman.phoenix.runner.InteractivePhoenixEnvironment;
import net.scheinerman.phoenix.runner.PhoenixEnvironment;

public class Main {
    private static TreeMap<String, Option> options;

    private static void initOptions() {
        options = new TreeMap();
        options.put("-version", new Version());
        options.put("-help", new Help());
    }

    public static void main(String ... args) {
        PhoenixEnvironment enviro;
        if (args.length == 0) {
            System.out.println("Phoenix: Arion (v.0.9.0 Beta) Interactive Shell");
            System.out.println("Type \"about\", \"license\", or \"copyright\" for additional information or \"exit\" to quit.");
            String input = "";
            Scanner in = new Scanner(System.in);
            enviro = new InteractivePhoenixEnvironment(true);
            while (!((InteractivePhoenixEnvironment)enviro).isExited()) {
                System.out.print(">>> ");
                input = in.nextLine();
                if (input.trim().endsWith(":")) {
                    String val = "";
                    do {
                        System.out.print("... ");
                        val = in.nextLine();
                        input = String.valueOf(input) + "\n" + val;
                    } while (!val.trim().equals(""));
                }
                ((InteractivePhoenixEnvironment)enviro).runCode(input);
            }
            System.exit(0);
        }
        if (args.length > 0) {
            Main.initOptions();
            int index = 0;
            while (index < args.length) {
                if (args[index].startsWith("-")) {
                    Option o = options.get(args[index]);
                    if (o == null) {
                        System.out.println("Unrecognized option");
                        System.exit(0);
                    } else {
                        o.operate();
                    }
                } else {
                    if (!args[index].matches(".+\\.phx")) {
                        System.out.println("Must have a '.phx' file extension.");
                        System.exit(0);
                    }
                    try {
                        String[] passedArgs = new String[args.length - index];
                        int i = 0;
                        while (i < passedArgs.length) {
                            passedArgs[i] = args[i + index];
                            ++i;
                        }
                        enviro = new PhoenixEnvironment(true);
                        enviro.run(new File(args[0]), passedArgs);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        System.out.println("No such file.");
                        e.printStackTrace();
                    }
                }
                ++index;
            }
        }
    }

    private static class Help
    implements Option {
        private Help() {
        }

        public String description() {
            return "Displays this help information, then exits.";
        }

        public void operate() {
            System.out.println("Usage: phoenix [-options] file [args...]");
            System.out.println("         (to execute a file)");
            System.out.println("       phoenix [-options]");
            System.out.println("         (to enter interactive mode)");
            System.out.println();
            for (String key : options.keySet()) {
                System.out.println("\t" + key + "\t" + ((Option)options.get(key)).description());
            }
            System.exit(0);
        }
    }

    private static interface Option {
        public String description();

        public void operate();
    }

    private static class Version
    implements Option {
        private Version() {
        }

        public String description() {
            return "Shows the current version number, then exits.";
        }

        public void operate() {
            System.out.println("Phoenix: Arion (v.1.0.0)");
            System.exit(0);
        }
    }
}

