/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.scheinerman.phoenix.library.AbstractModule;
import net.scheinerman.phoenix.runner.Runner;

public class PhoenixEnvironment {
    protected ArrayList<AbstractModule> modules = new ArrayList();
    private boolean includeDefaultModules;
    private InputStream inputStream;
    private PrintStream outputStream;
    private PrintStream errorStream;

    public PhoenixEnvironment(boolean includeDefaultModules) {
        this(includeDefaultModules, System.in, System.out, System.err);
    }

    public PhoenixEnvironment(boolean includeDefaultModules, InputStream inputStream, PrintStream outputStream, PrintStream errorStream) {
        this.includeDefaultModules = includeDefaultModules;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.errorStream = errorStream;
    }

    public void addModule(AbstractModule module) {
        this.modules.add(module);
    }

    public void resetModules() {
        this.modules = new ArrayList();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    public void run(File file, String[] args) throws FileNotFoundException {
        Runner r = new Runner(file, this.includeDefaultModules, this.inputStream, this.outputStream, this.errorStream);
        r.addModules(this.modules);
        r.run(args);
    }
}

