/*
 * Decompiled with CFR 0.152.
 */
package net.scheinerman.phoenix.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Scanner;
import net.scheinerman.phoenix.interpreter.Interpreter;
import net.scheinerman.phoenix.interpreter.InterpreterData;
import net.scheinerman.phoenix.interpreter.functions.Function;
import net.scheinerman.phoenix.interpreter.variables.Variable;
import net.scheinerman.phoenix.library.AbstractModule;
import net.scheinerman.phoenix.library.DefaultModules;
import net.scheinerman.phoenix.library.SystemFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Runner {
    private LinkedList<HashMap<String, Variable>> vat = new LinkedList();
    private LinkedList<HashMap<String, Function>> fat = new LinkedList();
    private Interpreter interpreter;
    private boolean includeDefaultModules;
    private File file;
    private ArrayList<AbstractModule> modules = new ArrayList();

    public Runner(File file, boolean includeDefaultModules, InputStream inputStream, PrintStream outputStream, PrintStream errorStream) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("No such run file.");
        }
        this.file = file;
        this.includeDefaultModules = includeDefaultModules;
        InterpreterData.IN = inputStream;
        InterpreterData.OUT = outputStream;
        InterpreterData.ERR = errorStream;
        this.vat.add(new HashMap());
        this.fat.add(new HashMap());
    }

    public void addModules(ArrayList<AbstractModule> modules) {
        this.modules.addAll(modules);
    }

    private void load() {
        for (AbstractModule module : this.modules) {
            module.load(this.fat.getFirst());
        }
        if (this.includeDefaultModules) {
            new DefaultModules().load(this.fat.getFirst());
        }
    }

    public void run(String[] args) {
        this.load();
        try {
            SystemFunctions.setArgs(args);
            Scanner sc = new Scanner(this.file);
            sc.useDelimiter("\\Z");
            if (sc.hasNext()) {
                this.interpreter = new Interpreter(true, this.file.getPath(), sc.next(), this.vat, this.fat);
                this.interpreter.run();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

